/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.provider;

import com.google.common.collect.Sets;
import com.terraforged.core.cell.Cell;
import com.terraforged.core.region.chunk.ChunkReader;
import com.terraforged.core.world.decorator.Decorator;
import com.terraforged.core.world.heightmap.WorldLookup;
import com.terraforged.core.world.terrain.Terrain;
import com.terraforged.mod.biome.map.BiomeMap;
import com.terraforged.mod.biome.modifier.BiomeModifierManager;
import com.terraforged.mod.biome.provider.AbstractBiomeProvider;
import com.terraforged.mod.biome.provider.BiomeHelper;
import com.terraforged.mod.chunk.TerraContainer;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.util.setup.SetupHooks;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.Structure;

public class BiomeProvider
extends AbstractBiomeProvider {
    private final BiomeMap biomeMap;
    private final TerraContext context;
    private final WorldLookup worldLookup;
    private final BiomeModifierManager modifierManager;
    private final Map<Biome, List<Decorator>> decorators = new HashMap<Biome, List<Decorator>>();

    public BiomeProvider(TerraContext context) {
        this.context = context;
        this.biomeMap = BiomeHelper.getDefaultBiomeMap();
        this.worldLookup = new WorldLookup(context.factory, context);
        this.modifierManager = SetupHooks.setup(new BiomeModifierManager(context, this.biomeMap), context.copy());
    }

    public TerraContext getContext() {
        return this.context;
    }

    public void lookupPos(int x, int z, Cell<Terrain> cell) {
        this.worldLookup.applyCell(cell, x, z);
    }

    public Cell<Terrain> lookupPos(int x, int z) {
        return this.worldLookup.getCell(x, z);
    }

    public boolean canSpawnAt(Cell<Terrain> cell) {
        return cell.tag != this.context.terrain.ocean && cell.tag != this.context.terrain.deepOcean && cell.value > this.context.levels.ground;
    }

    public Biome func_225526_b_(int x, int y, int z) {
        return this.getBiome(this.lookupPos(x <<= 2, z <<= 2), x, z);
    }

    @Override
    public Set<Biome> getBiomesInSquare(int centerX, int centerY, int centerZ, int radius) {
        int minX = centerX - radius >> 2;
        int minZ = centerZ - radius >> 2;
        int maxX = centerX + radius >> 2;
        int maxZ = centerZ + radius >> 2;
        int rangeX = maxX - minX + 1;
        int rangeZ = maxZ - minZ + 1;
        HashSet set = Sets.newHashSet();
        Cell<Terrain> cell = new Cell<Terrain>();
        for (int dz = 0; dz < rangeZ; ++dz) {
            for (int dx = 0; dx < rangeX; ++dx) {
                int x = minX + dx << 2;
                int z = minZ + dz << 2;
                this.worldLookup.applyCell(cell, x, z);
                Biome biome = this.getBiome(cell, x, z);
                set.add(biome);
            }
        }
        return set;
    }

    @Override
    public BlockPos findBiomePosition(int centerX, int centerY, int centerZ, int range, List<Biome> biomes, Random random) {
        int minX = centerX - range >> 2;
        int minZ = centerZ - range >> 2;
        int maxX = centerX + range >> 2;
        int maxZ = centerZ + range >> 2;
        int rangeX = maxX - minX + 1;
        int rangeZ = maxZ - minZ + 1;
        int y = centerY >> 2;
        BlockPos blockpos = null;
        int attempts = 0;
        Cell<Terrain> cell = new Cell<Terrain>();
        for (int dz = 0; dz < rangeZ; ++dz) {
            for (int dx = 0; dx < rangeX; ++dx) {
                int x = minX + dx << 2;
                int z = minZ + dz << 2;
                this.worldLookup.applyCell(cell, x, z);
                if (!biomes.contains(this.getBiome(cell, x, z))) continue;
                if (blockpos == null || random.nextInt(attempts + 1) == 0) {
                    blockpos = new BlockPos(x, y, z);
                }
                ++attempts;
            }
        }
        return blockpos;
    }

    public boolean func_205004_a(Structure<?> structureIn) {
        return this.field_205005_a.computeIfAbsent(structureIn, p_205006_1_ -> {
            for (Biome biome : defaultBiomes) {
                if (!biome.func_201858_a(p_205006_1_)) continue;
                return true;
            }
            return false;
        });
    }

    public Set<BlockState> func_205706_b() {
        if (this.field_205707_b.isEmpty()) {
            for (Biome biome : defaultBiomes) {
                this.field_205707_b.add(biome.func_203944_q().func_204108_a());
            }
        }
        return this.field_205707_b;
    }

    public BiomeModifierManager getModifierManager() {
        return this.modifierManager;
    }

    public List<Decorator> getDecorators(Biome biome) {
        return this.decorators.getOrDefault(biome, Collections.emptyList());
    }

    public TerraContainer createBiomeContainer(ChunkReader chunkReader) {
        TerraContainer.Builder builder = TerraContainer.builder();
        chunkReader.iterate((cell, dx, dz) -> {
            Biome biome = this.getBiome(cell, chunkReader.getBlockX() + dx, chunkReader.getBlockZ() + dz);
            builder.set(dx, dz, biome);
        });
        return builder.build(chunkReader);
    }

    public Biome getBiome(Cell<Terrain> cell, int x, int z) {
        if (cell.tag == this.context.terrain.wetlands) {
            return this.biomeMap.getWetland(cell.temperature, cell.moisture, cell.biome);
        }
        if (cell.value > this.context.levels.water) {
            return this.getModifierManager().modify(this.biomeMap.getBiome(cell), cell, x, z);
        }
        if (cell.tag == this.context.terrain.river || cell.tag == this.context.terrain.riverBanks || cell.tag == this.context.terrain.lake) {
            Biome biome = this.biomeMap.getBiome(cell);
            if (BiomeProvider.overridesRiver(biome)) {
                return biome;
            }
            return this.biomeMap.getRiver(cell.temperature, cell.moisture, cell.biome);
        }
        if (cell.tag == this.context.terrain.ocean) {
            return this.biomeMap.getOcean(cell.temperature, cell.moisture, cell.biome);
        }
        return this.biomeMap.getDeepOcean(cell.temperature, cell.moisture, cell.biome);
    }

    private static boolean overridesRiver(Biome biome) {
        return biome.func_201856_r() == Biome.Category.SWAMP || biome.func_201856_r() == Biome.Category.JUNGLE;
    }

    private static class SearchContext {
        private int count = 0;
        private boolean first = true;
        private final BlockPos.Mutable pos = new BlockPos.Mutable();

        private SearchContext() {
        }
    }
}

