/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.rivermap.river;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.util.concurrent.ObjectPool;
import com.terraforged.core.util.concurrent.cache.ExpiringEntry;
import com.terraforged.core.world.GeneratorContext;
import com.terraforged.core.world.heightmap.Heightmap;
import com.terraforged.core.world.rivermap.PosGenerator;
import com.terraforged.core.world.rivermap.RiverMapConfig;
import com.terraforged.core.world.rivermap.lake.Lake;
import com.terraforged.core.world.rivermap.lake.LakeConfig;
import com.terraforged.core.world.rivermap.river.River;
import com.terraforged.core.world.rivermap.river.RiverBounds;
import com.terraforged.core.world.rivermap.river.RiverConfig;
import com.terraforged.core.world.rivermap.river.RiverNode;
import com.terraforged.core.world.terrain.Terrain;
import com.terraforged.core.world.terrain.Terrains;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import me.dags.noise.domain.Domain;
import me.dags.noise.util.NoiseUtil;
import me.dags.noise.util.Vec2f;
import me.dags.noise.util.Vec2i;

public class RiverRegion
implements ExpiringEntry {
    public static final int SCALE = 12;
    private static final double MIN_FORK_ANGLE = 20.0;
    private static final double MAX_FORK_ANGLE = 60.0;
    private static final long EXPIRE_TIME = TimeUnit.SECONDS.toMillis(60L);
    private final Domain domain;
    private final Terrains terrains;
    private final LakeConfig lake;
    private final RiverConfig primary;
    private final RiverConfig secondary;
    private final RiverConfig tertiary;
    private final List<River> rivers;
    private final List<Lake> lakes = new LinkedList<Lake>();
    private final int primaryLimit;
    private final int secondaryLimit;
    private final int secondaryRelaxedLimit;
    private final int forkLimit;
    private final int tertiaryLimit;
    private final int primaryAttempts;
    private final int secondaryAttempts;
    private final int secondaryRelaxedAttempts;
    private final int forkAttempts;
    private final int tertiaryAttempts;
    private final long timestamp = System.currentTimeMillis() + EXPIRE_TIME;

    public RiverRegion(int regionX, int regionZ, Heightmap heightmap, GeneratorContext context, RiverMapConfig riverMapConfig) {
        int seed = new Random(NoiseUtil.seed(regionX, regionZ)).nextInt();
        this.lake = riverMapConfig.lakes;
        this.primary = riverMapConfig.primary;
        this.secondary = riverMapConfig.secondary;
        this.tertiary = riverMapConfig.tertiary;
        this.terrains = context.terrain;
        this.domain = Domain.warp(seed, 400, 1, 400.0).add(Domain.warp(seed + 1, 80, 1, 35.0));
        this.primaryLimit = NoiseUtil.round(10.0f * riverMapConfig.frequency);
        this.secondaryLimit = NoiseUtil.round(20.0f * riverMapConfig.frequency);
        this.secondaryRelaxedLimit = NoiseUtil.round(30.0f * riverMapConfig.frequency);
        this.forkLimit = NoiseUtil.round(40.0f * riverMapConfig.frequency);
        this.tertiaryLimit = NoiseUtil.round(50.0f * riverMapConfig.frequency);
        this.primaryAttempts = NoiseUtil.round(100.0f * riverMapConfig.frequency);
        this.secondaryAttempts = NoiseUtil.round(100.0f * riverMapConfig.frequency);
        this.secondaryRelaxedAttempts = NoiseUtil.round(50.0f * riverMapConfig.frequency);
        this.forkAttempts = NoiseUtil.round(75.0f * riverMapConfig.frequency);
        this.tertiaryAttempts = NoiseUtil.round(50.0f * riverMapConfig.frequency);
        try (ObjectPool.Item<Cell<Terrain>> cell = Cell.pooled();){
            PosGenerator pos = new PosGenerator(heightmap, this.domain, cell.getValue(), 4096, 275);
            this.rivers = this.generate(regionX, regionZ, pos);
        }
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void apply(Cell<Terrain> cell, float x, float z) {
        float px = this.domain.getX(x, z);
        float pz = this.domain.getY(x, z);
        for (River river : this.rivers) {
            river.apply(cell, px, pz);
        }
        for (Lake lake : this.lakes) {
            lake.apply(cell, px, pz);
        }
    }

    private List<River> generate(int regionX, int regionZ, PosGenerator pos) {
        int i;
        int x = RiverRegion.regionToBlock(regionX);
        int z = RiverRegion.regionToBlock(regionZ);
        long regionSeed = NoiseUtil.seed(regionX, regionZ);
        Random random = new Random(regionSeed);
        LinkedList<River> rivers = new LinkedList<River>();
        for (i = 0; rivers.size() < this.primaryLimit && i < this.primaryAttempts; ++i) {
            this.generateRiver(x, z, pos, this.primary, random, rivers);
        }
        for (i = 0; rivers.size() < this.secondaryLimit && i < this.secondaryAttempts; ++i) {
            this.generateRiver(x, z, pos, this.secondary, random, rivers);
        }
        for (i = 0; rivers.size() < this.secondaryRelaxedLimit && i < this.secondaryRelaxedAttempts; ++i) {
            this.generateRiverRelaxed(x, z, pos, this.secondary, random, rivers);
        }
        for (i = 0; rivers.size() < this.forkLimit && i < this.forkAttempts; ++i) {
            this.generateRiverFork(x, z, pos, this.tertiary, random, rivers);
        }
        for (i = 0; rivers.size() < this.tertiaryLimit && i < this.tertiaryAttempts; ++i) {
            this.generateRiver(x, z, pos, this.tertiary, random, rivers);
        }
        Collections.reverse(rivers);
        return rivers;
    }

    private boolean generateRiver(int x, int z, PosGenerator pos, RiverConfig config, Random random, List<River> rivers) {
        RiverNode p1 = pos.next(x, z, random, 50);
        if (p1 == null) {
            return false;
        }
        RiverNode p2 = pos.nextFrom(x, z, random, 50, p1, config.length2);
        if (p2 == null) {
            return false;
        }
        RiverBounds bounds = RiverBounds.fromNodes(p1, p2);
        for (River river : rivers) {
            if (!bounds.overlaps(river.bounds)) continue;
            return false;
        }
        this.generateLake(bounds, random);
        return rivers.add(new River(bounds, config, this.terrains, config.fade, 0.0));
    }

    private boolean generateRiverFork(int x, int z, PosGenerator pos, RiverConfig config, Random random, List<River> rivers) {
        double lenB;
        double lenA;
        int bz;
        int az;
        int bx;
        RiverNode p1 = pos.nextType(x, z, random, 50, RiverNode.Type.START);
        if (p1 == null) {
            return false;
        }
        River closest = null;
        float startDist2 = 2.1474836E9f;
        for (River river : rivers) {
            float d2 = RiverRegion.dist2(p1.x, p1.z, river.bounds.x1(), river.bounds.y1());
            if (!(d2 < startDist2)) continue;
            startDist2 = d2;
            closest = river;
        }
        if (closest == null) {
            return false;
        }
        float distance = 0.3f + random.nextFloat() * 0.3f;
        Vec2i fork = closest.bounds.pos(distance).toInt();
        float height = pos.getHeight(fork.x, fork.y);
        RiverNode.Type type = RiverNode.getType(height);
        if (type == RiverNode.Type.END) {
            return false;
        }
        int ax = fork.x - closest.bounds.x1();
        int dotAB = ax * (bx = fork.x - p1.x) + (az = fork.y - closest.bounds.y1()) * (bz = fork.y - p1.z);
        double radians = Math.acos((double)dotAB / ((lenA = Math.sqrt(ax * ax + az * az)) * (lenB = Math.sqrt(bx * bx + bz * bz))));
        double angle = Math.toDegrees(radians);
        if (angle < 20.0 || angle > 60.0) {
            return false;
        }
        RiverBounds bounds = new RiverBounds(p1.x, p1.z, fork.x, fork.y, 300);
        for (River river : rivers) {
            if (river == closest || !river.bounds.overlaps(bounds)) continue;
            return false;
        }
        this.generateLake(bounds, random);
        float forkWidth = (float)closest.config.bankWidth * distance * 0.6f;
        RiverConfig forkConfig = config.createFork(forkWidth);
        return rivers.add(new River(bounds, forkConfig, this.terrains, forkConfig.fade, 0.0, true));
    }

    private boolean generateRiverRelaxed(int x, int z, PosGenerator pos, RiverConfig config, Random random, List<River> rivers) {
        RiverNode p1 = pos.nextRelaxed(x, z, random, 50);
        if (p1 == null) {
            return false;
        }
        RiverNode p2 = pos.nextFromRelaxed(x, z, random, 50, p1, config.length2);
        if (p2 == null) {
            return false;
        }
        RiverBounds bounds = RiverBounds.fromNodes(p1, p2);
        for (River river : rivers) {
            if (!bounds.overlaps(river.bounds)) continue;
            return false;
        }
        this.generateLake(bounds, random);
        return rivers.add(new River(bounds, config, this.terrains, config.fade, 0.0));
    }

    private void generateLake(RiverBounds bounds, Random random) {
        if (random.nextFloat() < this.lake.chance) {
            float size = this.lake.sizeMin + random.nextFloat() * this.lake.sizeMax;
            float distance = this.lake.distanceMin + random.nextFloat() * this.lake.distanceMax;
            Vec2f center = bounds.pos(distance);
            this.lakes.add(new Lake(center, size, this.lake, this.terrains));
        }
    }

    private static float dist2(float x1, float y1, float x2, float y2) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        return dx * dx + dy * dy;
    }

    public static int regionToBlock(int value) {
        return value << 12;
    }

    public static int blockToRegion(int value) {
        return value >> 12;
    }
}

