/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.world.rivermap.lake;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.world.rivermap.lake.LakeConfig;
import com.terraforged.core.world.terrain.Terrain;
import com.terraforged.core.world.terrain.TerrainPopulator;
import com.terraforged.core.world.terrain.Terrains;
import me.dags.noise.Source;
import me.dags.noise.util.NoiseUtil;
import me.dags.noise.util.Vec2f;

public class Lake
extends TerrainPopulator {
    private static final int VALLEY_2 = 75625;
    private final float lakeDistance2;
    private final float valleyDistance2;
    private final float bankAlphaMin;
    private final float bankAlphaMax;
    private final float bankAlphaRange;
    private final Vec2f center;
    private final LakeConfig config;
    private final Terrains terrains;

    public Lake(Vec2f center, float radius, LakeConfig config, Terrains terrains) {
        super(Source.ZERO, terrains.lake);
        this.center = center;
        this.config = config;
        this.bankAlphaMin = config.bankMin;
        this.bankAlphaMax = Math.min(1.0f, this.bankAlphaMin + 0.275f);
        this.bankAlphaRange = this.bankAlphaMax - this.bankAlphaMin;
        this.lakeDistance2 = radius * radius;
        this.valleyDistance2 = 75625.0f - this.lakeDistance2;
        this.terrains = terrains;
    }

    @Override
    public void apply(Cell<Terrain> cell, float x, float z) {
        float distance2 = this.getDistance2(x, z);
        if (distance2 > 75625.0f) {
            return;
        }
        float bankHeight = this.getBankHeight(cell);
        if (distance2 > this.lakeDistance2) {
            if (cell.value < bankHeight) {
                return;
            }
            float valleyAlpha = 1.0f - (distance2 - this.lakeDistance2) / this.valleyDistance2;
            cell.value = NoiseUtil.lerp(cell.value, bankHeight, valleyAlpha);
            return;
        }
        cell.value = Math.min(bankHeight, cell.value);
        if (distance2 < this.lakeDistance2) {
            float depthAlpha = 1.0f - distance2 / this.lakeDistance2;
            float lakeDepth = Math.min(cell.value, this.config.depth);
            cell.value = NoiseUtil.lerp(cell.value, lakeDepth, depthAlpha);
            cell.tag = this.terrains.lake;
        }
    }

    @Override
    public void tag(Cell<Terrain> cell, float x, float z) {
        cell.tag = this.terrains.lake;
    }

    private float getDistance2(float x, float z) {
        float dx = this.center.x - x;
        float dz = this.center.y - z;
        return dx * dx + dz * dz;
    }

    private float getBankHeight(Cell<Terrain> cell) {
        float bankHeightAlpha = NoiseUtil.map(cell.value, this.bankAlphaMin, this.bankAlphaMax, this.bankAlphaRange);
        return NoiseUtil.lerp(this.config.bankMin, this.config.bankMax, bankHeightAlpha);
    }
}

