/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.util.grid;

import com.terraforged.core.util.grid.FixedList;
import java.util.List;

public class MappedList<T>
extends FixedList<T> {
    private final float min;
    private final float range;

    public MappedList(T[] elements, float min, float range) {
        super(elements);
        this.min = min;
        this.range = range;
    }

    @Override
    public int indexOf(float value) {
        return super.indexOf((value - this.min) / this.range);
    }

    public static <T> MappedList<T> of(List<T> list, float min, float range) {
        return new MappedList<Object>(list.toArray(), min, range);
    }
}

