/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.util.concurrent.cache;

import com.terraforged.core.util.concurrent.ThreadPool;
import com.terraforged.core.util.concurrent.cache.ExpiringEntry;
import com.terraforged.core.util.concurrent.cache.SynchronizedLongMap;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;

public class Cache<V extends ExpiringEntry>
implements Runnable {
    private final long expireMS;
    private final long intervalMS;
    private final SynchronizedLongMap<V> map;
    private final ThreadPool threadPool = ThreadPool.getPool();
    private volatile long timestamp = 0L;

    public Cache(long expireTime, long interval, TimeUnit unit) {
        this.expireMS = unit.toMillis(expireTime);
        this.intervalMS = unit.toMillis(interval);
        this.map = new SynchronizedLongMap(100);
    }

    public void remove(long key) {
        this.map.remove(key);
    }

    public V computeIfAbsent(long key, LongFunction<V> func) {
        ExpiringEntry v = (ExpiringEntry)this.map.computeIfAbsent(key, func);
        this.queueUpdate();
        return (V)v;
    }

    private void queueUpdate() {
        long now = System.currentTimeMillis();
        if (now - this.timestamp > this.intervalMS) {
            this.timestamp = now;
            this.threadPool.submit(this);
        }
    }

    @Override
    public void run() {
        long now = this.timestamp;
        this.map.removeIf(val -> now - val.getTimestamp() > this.expireMS);
    }
}

