/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.network.EnumAccessType;
import sonar.fluxnetworks.api.network.EnumSecurityType;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.NetworkMember;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.utils.Coord4D;
import sonar.fluxnetworks.api.utils.EnergyType;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.common.connection.FluxLiteNetwork;
import sonar.fluxnetworks.common.connection.FluxNetworkInvalid;
import sonar.fluxnetworks.common.connection.FluxNetworkServer;
import sonar.fluxnetworks.common.data.FluxNetworkData;

public class FluxNetworkCache {
    public static FluxNetworkCache instance = new FluxNetworkCache();
    public Map<Integer, IFluxNetwork> networks = new HashMap<Integer, IFluxNetwork>();
    public boolean superAdminClient = false;

    public void clearNetworks() {
        FluxNetworkData.clear();
    }

    public void clearClientCache() {
        this.networks.clear();
        this.superAdminClient = false;
    }

    public boolean hasSpaceLeft(PlayerEntity player) {
        if (FluxConfig.maximumPerPlayer == -1) {
            return true;
        }
        UUID uuid = PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH());
        List created = this.getAllNetworks().stream().filter(s -> s.getSetting(NetworkSettings.NETWORK_OWNER).equals(uuid)).collect(Collectors.toList());
        return created.size() < FluxConfig.maximumPerPlayer;
    }

    public IFluxNetwork createdNetwork(PlayerEntity player, String name, int color, EnumSecurityType securityType, EnergyType energyType, String password) {
        UUID uuid = PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH());
        NetworkMember owner = NetworkMember.createNetworkMember(player, EnumAccessType.OWNER);
        FluxNetworkServer network = new FluxNetworkServer(this.getUniqueID(), name, securityType, color, uuid, energyType, password);
        network.getSetting(NetworkSettings.NETWORK_PLAYERS).add(owner);
        FluxNetworkData.get().addNetwork(network);
        return network;
    }

    private int getUniqueID() {
        return FluxNetworkData.get().uniqueID++;
    }

    public void updateClientFromPacket(Map<Integer, CompoundNBT> serverSideNetworks, NBTType type) {
        serverSideNetworks.forEach((i, n) -> {
            IFluxNetwork network = this.networks.get(i);
            if (type == NBTType.NETWORK_CLEAR && network != null) {
                this.networks.remove(i);
                return;
            }
            if (network == null) {
                network = new FluxLiteNetwork();
                network.readNetworkNBT((CompoundNBT)n, type);
                this.networks.put((Integer)i, network);
            } else {
                network.readNetworkNBT((CompoundNBT)n, type);
            }
        });
    }

    public void updateClientConnections(int networkID, List<CompoundNBT> tags) {
        IFluxNetwork network = this.networks.get(networkID);
        if (network != null) {
            List<IFluxConnector> connectors = network.getSetting(NetworkSettings.ALL_CONNECTORS);
            tags.forEach(t -> {
                Coord4D coord4D = new Coord4D((CompoundNBT)t);
                connectors.stream().filter(f -> f.getCoords().equals(coord4D)).findFirst().ifPresent(f -> f.readCustomNBT((CompoundNBT)t, NBTType.DEFAULT));
            });
        }
    }

    public IFluxNetwork getNetwork(int id) {
        return FluxNetworkData.get().networks.getOrDefault(id, FluxNetworkInvalid.instance);
    }

    public Collection<IFluxNetwork> getAllNetworks() {
        return FluxNetworkData.get().networks.values();
    }

    public IFluxNetwork getClientNetwork(int id) {
        return this.networks.getOrDefault(id, FluxNetworkInvalid.instance);
    }

    public List<IFluxNetwork> getAllClientNetworks() {
        return new ArrayList<IFluxNetwork>(this.networks.values());
    }
}

