/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.crafting.ingredient;

import com.blakebr0.ironjetpacks.crafting.ModRecipeSerializers;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class JetpackIngredient
extends Ingredient {
    public static final List<JetpackItem> ALL_JETPACKS = new ArrayList<JetpackItem>();
    private ItemStack[] stacks;
    private IntList stacksPacked;
    private int tier;

    public JetpackIngredient(int tier) {
        super(Stream.of(new Ingredient.IItemList[0]));
        this.tier = tier;
    }

    public ItemStack[] func_193365_a() {
        if (this.stacks == null) {
            this.stacks = (ItemStack[])ALL_JETPACKS.stream().filter(j -> j.getJetpack().tier == this.tier).map(ItemStack::new).toArray(ItemStack[]::new);
        }
        return this.stacks;
    }

    public IntList func_194139_b() {
        if (this.stacksPacked == null) {
            if (this.stacks == null) {
                this.stacks = (ItemStack[])ALL_JETPACKS.stream().filter(j -> j.getJetpack().tier == this.tier).map(ItemStack::new).toArray(ItemStack[]::new);
            }
            this.stacksPacked = new IntArrayList(this.stacks.length);
            Arrays.stream(this.stacks).forEach(s -> this.stacksPacked.add(RecipeItemHelper.func_194113_b((ItemStack)s)));
            this.stacksPacked.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.stacksPacked;
    }

    public boolean test(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (ALL_JETPACKS.stream().noneMatch(j -> j.getJetpack().tier == this.tier)) {
            return stack.func_190926_b();
        }
        if (this.stacks == null) {
            this.stacks = (ItemStack[])ALL_JETPACKS.stream().filter(j -> j.getJetpack().tier == this.tier).map(ItemStack::new).toArray(ItemStack[]::new);
        }
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_77973_b() != stack.func_77973_b()) continue;
            return true;
        }
        return false;
    }

    public boolean func_203189_d() {
        return !(!ALL_JETPACKS.stream().noneMatch(j -> j.getJetpack().tier == this.tier) || this.stacks != null && this.stacks.length != 0 || this.stacksPacked != null && !this.stacksPacked.isEmpty());
    }

    public JsonElement func_200304_c() {
        JsonArray json = new JsonArray();
        ALL_JETPACKS.stream().filter(j -> j.getJetpack().tier == this.tier).filter(h -> h.getRegistryName() != null).forEach(h -> {
            JsonObject obj = new JsonObject();
            obj.addProperty("item", h.getRegistryName().toString());
            json.add((JsonElement)obj);
        });
        return json;
    }

    protected void invalidate() {
        this.stacks = null;
        this.stacksPacked = null;
    }

    public boolean isSimple() {
        return true;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return ModRecipeSerializers.JETPACK_INGREDIENT;
    }

    public static class Serializer
    implements IIngredientSerializer<JetpackIngredient> {
        public JetpackIngredient parse(PacketBuffer buffer) {
            return new JetpackIngredient(buffer.readInt());
        }

        public JetpackIngredient parse(JsonObject json) {
            return new JetpackIngredient(json.get("tier").getAsInt());
        }

        public void write(PacketBuffer buffer, JetpackIngredient ingredient) {
            buffer.writeInt(ingredient.tier);
        }
    }
}

