/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.modcompat;

import javax.annotation.Nullable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.colossalchests.Capabilities;
import org.cyclops.colossalchests.ColossalChests;
import org.cyclops.colossalchests.tileentity.TileColossalChest;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.inventory.IndexedSlotlessItemHandlerWrapper;
import org.cyclops.cyclopscore.modcompat.ICompatInitializer;
import org.cyclops.cyclopscore.modcompat.IModCompat;
import org.cyclops.cyclopscore.modcompat.capabilities.CapabilityConstructorRegistry;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultCapabilityProvider;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;
import org.cyclops.cyclopscore.modcompat.capabilities.SimpleCapabilityConstructor;

public class CommonCapabilitiesModCompat
implements IModCompat {
    public String getId() {
        return "commoncapabilities";
    }

    public boolean isEnabledDefault() {
        return true;
    }

    public String getComment() {
        return "If slotless item handlers should be registered to colossal chests.";
    }

    public ICompatInitializer createInitializer() {
        return () -> {
            CapabilityConstructorRegistry registry = ColossalChests._instance.getCapabilityConstructorRegistry();
            registry.registerTile(TileColossalChest.class, (ICapabilityConstructor)new SimpleCapabilityConstructor<ISlotlessItemHandler, TileColossalChest>(){

                public Capability<ISlotlessItemHandler> getCapability() {
                    return Capabilities.SLOTLESS_ITEMHANDLER;
                }

                @Nullable
                public ICapabilityProvider createProvider(TileColossalChest host) {
                    Wrapper optionalSlotlessItemHandler = new Wrapper();
                    optionalSlotlessItemHandler.set((Object)LazyOptional.of(() -> {
                        LazyOptional optionalItemHandler = host.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                        optionalItemHandler.addListener(o -> ((LazyOptional)optionalSlotlessItemHandler.get()).invalidate());
                        return new IndexedSlotlessItemHandlerWrapper((IItemHandler)optionalItemHandler.orElse(null), (IndexedSlotlessItemHandlerWrapper.IInventoryIndexReference)host.getInventory());
                    }));
                    return new DefaultCapabilityProvider(this::getCapability, (LazyOptional)optionalSlotlessItemHandler.get());
                }
            });
        };
    }
}

