/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.nbt.path.parse;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import org.cyclops.cyclopscore.nbt.path.INbtPathExpression;
import org.cyclops.cyclopscore.nbt.path.NbtPathExpressionMatches;
import org.cyclops.cyclopscore.nbt.path.navigate.INbtPathNavigation;
import org.cyclops.cyclopscore.nbt.path.navigate.NbtPathNavigationAdapter;
import org.cyclops.cyclopscore.nbt.path.parse.INbtPathExpressionParseHandler;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionExecutionContext;

public class NbtPathExpressionParseHandlerUnion
implements INbtPathExpressionParseHandler {
    private static final Pattern REGEX_BRACKETS = Pattern.compile("^\\[([^\\]]+(,[^\\]]+)+)]");

    @Override
    @Nullable
    public INbtPathExpressionParseHandler.HandleResult handlePrefixOf(String nbtPathExpression, int pos) {
        Matcher matcher = REGEX_BRACKETS.matcher(nbtPathExpression).region(pos, nbtPathExpression.length());
        if (!matcher.find()) {
            return INbtPathExpressionParseHandler.HandleResult.INVALID;
        }
        String[] contents = matcher.group(1).split(",");
        ArrayList childNames = Lists.newArrayList();
        ArrayList childIndexes = Lists.newArrayList();
        int expressionLength = 1;
        for (String match : contents) {
            expressionLength += 1 + match.length();
            try {
                childIndexes.add(Integer.parseInt(match));
                if (childNames.isEmpty()) continue;
                return INbtPathExpressionParseHandler.HandleResult.INVALID;
            }
            catch (NumberFormatException e) {
                childNames.add(match);
                if (childIndexes.isEmpty()) continue;
                return INbtPathExpressionParseHandler.HandleResult.INVALID;
            }
        }
        return new INbtPathExpressionParseHandler.HandleResult(new Expression(childNames, childIndexes), expressionLength);
    }

    public static class Expression
    implements INbtPathExpression {
        private final List<String> childNames;
        private final List<Integer> childIndexes;

        public Expression(List<String> childNames, List<Integer> childIndexes) {
            this.childNames = childNames;
            this.childIndexes = childIndexes;
        }

        public List<String> getChildNames() {
            return this.childNames;
        }

        public List<Integer> getChildIndexes() {
            return this.childIndexes;
        }

        @Override
        public NbtPathExpressionMatches matchContexts(Stream<NbtPathExpressionExecutionContext> executionContexts) {
            return new NbtPathExpressionMatches(executionContexts.flatMap(executionContext -> {
                INBT nbt = executionContext.getCurrentTag();
                if (!this.getChildIndexes().isEmpty() && nbt.func_74732_a() == 9) {
                    ListNBT tag = (ListNBT)nbt;
                    return this.getChildIndexes().stream().map(arg_0 -> ((ListNBT)tag).get(arg_0)).filter(subTag -> subTag.func_74732_a() != 0).map(subTag -> new NbtPathExpressionExecutionContext((INBT)subTag, (NbtPathExpressionExecutionContext)executionContext));
                }
                if (!this.getChildNames().isEmpty() && nbt.func_74732_a() == 10) {
                    CompoundNBT tag = (CompoundNBT)nbt;
                    return this.getChildNames().stream().map(arg_0 -> ((CompoundNBT)tag).func_74781_a(arg_0)).filter(Objects::nonNull).map(subTag -> new NbtPathExpressionExecutionContext((INBT)subTag, (NbtPathExpressionExecutionContext)executionContext));
                }
                return null;
            }).filter(Objects::nonNull));
        }

        @Override
        public INbtPathNavigation asNavigation(@Nullable INbtPathNavigation child) {
            if (!this.getChildNames().isEmpty()) {
                return new NbtPathNavigationAdapter(this.getChildNames(), child);
            }
            throw new UnsupportedOperationException("NbtPathExpressionParseHandlerUnion.Expression#asNavigation is not implemented for lists");
        }
    }
}

