/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurablePropertyData;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.CyclopsCoreConfigException;
import org.cyclops.cyclopscore.init.ModBase;

public abstract class ExtendedConfig<C extends ExtendedConfig<C, I>, I>
implements Comparable<ExtendedConfig<C, I>> {
    private final ModBase mod;
    private final String namedId;
    private final Function<C, ? extends I> elementConstructor;
    private I instance;
    public Map<String, ConfigurablePropertyData<?>> configProperties = Maps.newHashMap();

    public ExtendedConfig(ModBase mod, String namedId, Function<C, ? extends I> elementConstructor) {
        this.mod = mod;
        this.namedId = namedId.toLowerCase(Locale.ROOT);
        this.elementConstructor = elementConstructor;
        try {
            this.generateConfigProperties();
        }
        catch (IllegalAccessException | IllegalArgumentException e1) {
            e1.printStackTrace();
        }
    }

    private void generateConfigProperties() throws IllegalArgumentException, IllegalAccessException {
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigurableProperty.class)) continue;
            ConfigurableProperty annotation = field.getAnnotation(ConfigurableProperty.class);
            ConfigurablePropertyData<Object> configProperty = new ConfigurablePropertyData<Object>(this.getMod(), annotation.category(), this.getConfigPropertyPrefix(annotation) + "." + field.getName(), field.get(null), annotation.comment(), annotation.isCommandable(), annotation.configLocation(), field, annotation.requiresWorldRestart(), annotation.requiresMcRestart(), annotation.showInGui(), annotation.minimalValue(), annotation.maximalValue());
            this.configProperties.put(configProperty.getName(), configProperty);
        }
    }

    protected String getConfigPropertyPrefix(ConfigurableProperty annotation) {
        return annotation.namedId().isEmpty() ? this.getNamedId() : annotation.namedId();
    }

    protected void initializeInstance() {
        I instance = this.getElementConstructor().apply(this.downCast());
        if (this.instance == null) {
            this.instance = instance;
        } else {
            this.showDoubleInitError();
        }
    }

    protected void save() {
        if (this.getConfigurableType().hasUniqueInstance()) {
            this.initializeInstance();
        }
    }

    public abstract ConfigurableType getConfigurableType();

    public abstract String getTranslationKey();

    public String getFullTranslationKey() {
        return this.getTranslationKey();
    }

    public I getInstance() {
        if (!this.getConfigurableType().hasUniqueInstance()) {
            throw new IllegalStateException("Tried calling getInstance() on a config of type that has no unique instances.");
        }
        if (this.instance == null) {
            this.save();
        }
        return this.instance;
    }

    public String getSubUniqueName() {
        return this.getNamedId();
    }

    public void onRegistered() {
    }

    public void onForgeRegistered() {
    }

    @Override
    public int compareTo(ExtendedConfig<C, I> o) {
        return this.getNamedId().compareTo(o.getNamedId());
    }

    public void showDoubleInitError() {
        String message = this.getClass() + " caused a double registration of " + this.getInstance() + ". This is an error in the mod code.";
        this.mod.log(Level.FATAL, message);
        throw new CyclopsCoreConfigException(message);
    }

    @Deprecated
    public C downCast() {
        return (C)this;
    }

    public ModBase getMod() {
        return this.mod;
    }

    public String getNamedId() {
        return this.namedId;
    }

    public Function<C, ? extends I> getElementConstructor() {
        return this.elementConstructor;
    }
}

