/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.capability.fluid;

import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacityConfig;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;

public class FluidHandlerItemCapacity
extends FluidHandlerItemStack
implements IFluidHandlerItemCapacity {
    private final Fluid fluid;

    public FluidHandlerItemCapacity(ItemStack container, int capacity) {
        this(container, capacity, null);
    }

    public FluidHandlerItemCapacity(ItemStack container, int capacity, Fluid fluid) {
        super(container, capacity);
        this.fluid = fluid;
    }

    public boolean canFillFluidType(FluidStack resource) {
        return this.fluid == null || resource == null || this.fluid == resource.getFluid();
    }

    @Override
    public void setCapacity(int capacity) {
        CompoundNBT tag = this.getContainer().func_196082_o();
        this.capacity = capacity;
        tag.func_74768_a("capacity", capacity);
    }

    @Override
    public int getCapacity() {
        CompoundNBT tag = this.getContainer().func_196082_o();
        return tag.func_150297_b("capacity", 3) ? tag.func_74762_e("capacity") : this.capacity;
    }

    @Nullable
    public FluidStack getFluid() {
        this.capacity = this.getCapacity();
        return super.getFluid();
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        return capability == FluidHandlerItemCapacityConfig.CAPABILITY ? LazyOptional.of(() -> this).cast() : super.getCapability(capability, facing);
    }

    public static class Storage
    implements Capability.IStorage<IFluidHandlerItemCapacity> {
        public INBT writeNBT(Capability<IFluidHandlerItemCapacity> capability, IFluidHandlerItemCapacity instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            FluidStack fluid = ((FluidHandlerItemCapacity)instance).getFluid();
            if (fluid != null) {
                fluid.writeToNBT(nbt);
            } else {
                nbt.func_74778_a("Empty", "");
            }
            nbt.func_74768_a("capacity", instance.getCapacity());
            return nbt;
        }

        public void readNBT(Capability<IFluidHandlerItemCapacity> capability, IFluidHandlerItemCapacity instance, Direction side, INBT nbt) {
            CompoundNBT tags = (CompoundNBT)nbt;
            if (tags.func_150297_b("capacity", 3)) {
                instance.setCapacity(tags.func_74762_e("capacity"));
            }
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)tags);
            ((FluidHandlerItemCapacity)instance).setFluid(fluid);
        }
    }
}

