/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.gui.inventory;

import com.lothrazar.storagenetwork.api.data.IItemStackMatcher;
import com.lothrazar.storagenetwork.api.data.ItemStackHandlerEx;
import com.lothrazar.storagenetwork.api.data.ItemStackMatcher;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class FilterItemStackHandler
extends ItemStackHandlerEx {
    public static final int FILTER_SIZE = 18;
    public boolean tags = false;
    public boolean nbt = false;
    public boolean isWhitelist = true;

    public FilterItemStackHandler() {
        super(18);
    }

    public void setMatchOreDict(boolean ores) {
        this.tags = ores;
    }

    public void setMatchNbt(boolean nbt) {
        this.nbt = nbt;
    }

    public void setIsWhitelist(boolean whitelist) {
        this.isWhitelist = whitelist;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return 1;
    }

    public List<IItemStackMatcher> getStackMatchers() {
        return this.getStacks().stream().map(stack -> new ItemStackMatcher((ItemStack)stack, this.tags, this.nbt)).collect(Collectors.toList());
    }

    public void clear() {
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            this.setStackInSlot(slot, ItemStack.field_190927_a);
        }
    }

    public boolean exactStackAlreadyInList(ItemStack stack) {
        return this.getStackMatchers().stream().anyMatch(matcher -> matcher.match(stack));
    }

    public boolean isStackFiltered(ItemStack stack) {
        if (this.isWhitelist) {
            return this.getStackMatchers().stream().noneMatch(matcher -> matcher.match(stack));
        }
        return this.getStackMatchers().stream().anyMatch(matcher -> matcher.match(stack));
    }

    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        CompoundNBT rulesTag = nbt.func_74775_l("rules");
        this.tags = rulesTag.func_74767_n("tags");
        this.nbt = rulesTag.func_74767_n("nbt");
        this.isWhitelist = rulesTag.func_74767_n("whitelist");
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT result = super.serializeNBT();
        CompoundNBT rulesTag = new CompoundNBT();
        rulesTag.func_74757_a("tags", this.tags);
        rulesTag.func_74757_a("nbt", this.nbt);
        rulesTag.func_74757_a("whitelist", this.isWhitelist);
        result.func_218657_a("rules", (INBT)rulesTag);
        return result;
    }
}

