/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.dimensionalcell.client;

import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.RFToolsPower;
import mcjty.rftoolspower.modules.dimensionalcell.DimensionalCellConfiguration;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellContainer;
import mcjty.rftoolspower.modules.dimensionalcell.blocks.DimensionalCellTileEntity;
import mcjty.rftoolspower.setup.RFToolsPowerMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;

public class GuiDimensionalCell
extends GenericGuiContainer<DimensionalCellTileEntity, DimensionalCellContainer> {
    public static final int POWERCELL_WIDTH = 180;
    public static final int POWERCELL_HEIGHT = 152;
    private EnergyBar energyBar;
    private Button stats;
    private static long lastTime = 0L;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolspower", "textures/gui/dimensionalcell.png");

    public GuiDimensionalCell(DimensionalCellTileEntity te, DimensionalCellContainer container, PlayerInventory inventory) {
        super((ModBase)RFToolsPower.instance, (GenericTileEntity)te, (Container)container, inventory, ManualHelper.create((String)"rftoolspower:powerstorage/dimensionalcell"));
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public void init() {
        super.init();
        this.energyBar = ((EnergyBar)new EnergyBar().vertical().maxValue(1000L).hint(10, 7, 8, 54)).showText(false);
        this.energyBar.value(0L);
        Button allNone = (Button)((Button)Widgets.button((int)140, (int)10, (int)32, (int)15, (String)"None").name("allnone")).tooltips(new String[]{"Set all sides to 'none'"});
        Button allInput = (Button)((Button)Widgets.button((int)140, (int)27, (int)32, (int)15, (String)"In").name("allinput")).tooltips(new String[]{"Set all sides to", "accept energy"});
        Button allOutput = (Button)((Button)Widgets.button((int)140, (int)44, (int)32, (int)15, (String)"Out").name("alloutput")).tooltips(new String[]{"Set all sides to", "send energy"});
        this.stats = (Button)((Button)Widgets.button((int)100, (int)10, (int)32, (int)15, (String)"Stats").name("clearstats")).tooltips(new String[]{"Power statistics. Press to clear:"});
        Label label = (Label)Widgets.label((int)26, (int)30, (int)40, (int)18, (String)"Link:").tooltips(new String[]{"Link a powercard to card", "on the left"});
        Panel toplevel = (Panel)((Panel)Widgets.positional().background(iconLocation)).children(new Widget[]{this.energyBar, allNone, allInput, allOutput, label, this.stats});
        toplevel.bounds(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.window.action(RFToolsPowerMessages.INSTANCE, "allnone", this.tileEntity, "setNone");
        this.window.action(RFToolsPowerMessages.INSTANCE, "allinput", this.tileEntity, "setInput");
        this.window.action(RFToolsPowerMessages.INSTANCE, "alloutput", this.tileEntity, "setOutput");
        this.window.action(RFToolsPowerMessages.INSTANCE, "clearstats", this.tileEntity, "clearStats");
        this.requestRF();
    }

    private void requestRF() {
        if (System.currentTimeMillis() - lastTime > 250L) {
            lastTime = System.currentTimeMillis();
            ((DimensionalCellTileEntity)this.tileEntity).requestDataFromServer(RFToolsPowerMessages.INSTANCE, "getInfo", TypedMap.EMPTY);
        }
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.drawWindow();
        this.requestRF();
        this.stats.tooltips(new String[]{"Power statistics. Press to clear:", "Inserted: " + DimensionalCellTileEntity.tooltipInserted, "Extracted: " + DimensionalCellTileEntity.tooltipExtracted});
        int maxValue = (DimensionalCellTileEntity.tooltipBlocks - DimensionalCellTileEntity.tooltipAdvancedBlocks - DimensionalCellTileEntity.tooltipSimpleBlocks) * (Integer)DimensionalCellConfiguration.rfPerNormalCell.get();
        maxValue += DimensionalCellTileEntity.tooltipAdvancedBlocks * (Integer)DimensionalCellConfiguration.rfPerNormalCell.get() * (Integer)DimensionalCellConfiguration.advancedFactor.get();
        this.energyBar.maxValue((long)(maxValue += DimensionalCellTileEntity.tooltipSimpleBlocks * (Integer)DimensionalCellConfiguration.rfPerNormalCell.get() / (Integer)DimensionalCellConfiguration.simpleFactor.get()));
        this.energyBar.value((long)DimensionalCellTileEntity.tooltipEnergy);
    }
}

