/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.tile;

import com.raoulvdberge.refinedpipes.network.NetworkManager;
import com.raoulvdberge.refinedpipes.network.pipe.Pipe;
import com.raoulvdberge.refinedpipes.network.pipe.attachment.Attachment;
import com.raoulvdberge.refinedpipes.network.pipe.attachment.AttachmentManager;
import com.raoulvdberge.refinedpipes.network.pipe.attachment.ClientAttachmentManager;
import com.raoulvdberge.refinedpipes.network.pipe.attachment.DummyAttachmentManager;
import com.raoulvdberge.refinedpipes.tile.BaseTileEntity;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public abstract class PipeTileEntity
extends BaseTileEntity {
    public static final ModelProperty<ResourceLocation[]> ATTACHMENTS_PROPERTY = new ModelProperty();
    private final AttachmentManager clientAttachmentManager = new ClientAttachmentManager();

    public PipeTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public AttachmentManager getAttachmentManager() {
        if (this.field_145850_b.field_72995_K) {
            return this.clientAttachmentManager;
        }
        Pipe pipe = NetworkManager.get(this.field_145850_b).getPipe(this.field_174879_c);
        if (pipe != null) {
            return pipe.getAttachmentManager();
        }
        return DummyAttachmentManager.INSTANCE;
    }

    public void func_145829_t() {
        NetworkManager mgr;
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K && (mgr = NetworkManager.get(this.field_145850_b)).getPipe(this.field_174879_c) == null) {
            mgr.addPipe(this.createPipe(this.field_145850_b, this.field_174879_c));
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            NetworkManager mgr = NetworkManager.get(this.field_145850_b);
            Pipe pipe = mgr.getPipe(this.field_174879_c);
            if (pipe != null) {
                this.spawnDrops(pipe);
                for (Attachment attachment : pipe.getAttachmentManager().getAttachments()) {
                    InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)attachment.getDrop());
                }
            }
            mgr.removePipe(this.field_174879_c);
        }
    }

    protected void spawnDrops(Pipe pipe) {
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ATTACHMENTS_PROPERTY, (Object)this.getAttachmentManager().getState()).build();
    }

    @Override
    public CompoundNBT writeUpdate(CompoundNBT tag) {
        this.getAttachmentManager().writeUpdate(tag);
        return tag;
    }

    @Override
    public void readUpdate(CompoundNBT tag) {
        this.getAttachmentManager().readUpdate(tag);
        this.requestModelDataUpdate();
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    protected abstract Pipe createPipe(World var1, BlockPos var2);
}

