/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.network.item;

import com.raoulvdberge.refinedpipes.network.Network;
import com.raoulvdberge.refinedpipes.network.graph.NetworkGraphScannerResult;
import com.raoulvdberge.refinedpipes.network.item.routing.DestinationPathCache;
import com.raoulvdberge.refinedpipes.network.item.routing.DestinationPathCacheFactory;
import com.raoulvdberge.refinedpipes.network.item.routing.EdgeFactory;
import com.raoulvdberge.refinedpipes.network.pipe.Destination;
import com.raoulvdberge.refinedpipes.network.pipe.DestinationType;
import com.raoulvdberge.refinedpipes.network.pipe.Pipe;
import com.raoulvdberge.refinedpipes.routing.Graph;
import com.raoulvdberge.refinedpipes.routing.Node;
import com.raoulvdberge.refinedpipes.routing.NodeIndex;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemNetwork
extends Network {
    public static final ResourceLocation TYPE = new ResourceLocation("refinedpipes", "item");
    private DestinationPathCache destinationPathCache;

    public ItemNetwork(BlockPos originPos, String id) {
        super(originPos, id);
    }

    @Override
    public NetworkGraphScannerResult scanGraph(World world, BlockPos pos) {
        NetworkGraphScannerResult result = super.scanGraph(world, pos);
        this.updateRouting(result, this.graph.getDestinations(DestinationType.ITEM_HANDLER));
        return result;
    }

    @Override
    public void onMergedWith(Network mainNetwork) {
    }

    @Override
    public ResourceLocation getType() {
        return TYPE;
    }

    private void updateRouting(NetworkGraphScannerResult result, List<Destination> destinations) {
        List nodes = this.buildNodes(result.getFoundPipes());
        NodeIndex<BlockPos> nodeIndex = NodeIndex.of(nodes);
        EdgeFactory edgeFactory = new EdgeFactory(nodeIndex, result.getRequests());
        List edges = edgeFactory.create();
        Graph<BlockPos> graph = new Graph<BlockPos>(nodes, edges);
        DestinationPathCacheFactory destinationPathCacheFactory = new DestinationPathCacheFactory(graph, nodeIndex, destinations);
        this.destinationPathCache = destinationPathCacheFactory.create();
    }

    private List<Node<BlockPos>> buildNodes(Set<Pipe> pipes) {
        return pipes.stream().map(p -> new Node<BlockPos>(p.getPos())).collect(Collectors.toList());
    }

    public DestinationPathCache getDestinationPathCache() {
        return this.destinationPathCache;
    }
}

