/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.network;

import com.raoulvdberge.refinedpipes.network.NetworkFactory;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkRegistry {
    private static final Logger LOGGER = LogManager.getLogger(NetworkRegistry.class);
    public static final NetworkRegistry INSTANCE = new NetworkRegistry();
    private final Map<ResourceLocation, NetworkFactory> factories = new HashMap<ResourceLocation, NetworkFactory>();

    private NetworkRegistry() {
    }

    public void addFactory(ResourceLocation type, NetworkFactory factory) {
        if (this.factories.containsKey(type)) {
            throw new RuntimeException("Cannot register duplicate network type " + type.toString());
        }
        LOGGER.debug("Registering network factory {}", (Object)type.toString());
        this.factories.put(type, factory);
    }

    @Nullable
    public NetworkFactory getFactory(ResourceLocation type) {
        return this.factories.get(type);
    }
}

