/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.network;

import com.raoulvdberge.refinedpipes.network.graph.NetworkGraph;
import com.raoulvdberge.refinedpipes.network.graph.NetworkGraphScannerResult;
import com.raoulvdberge.refinedpipes.network.pipe.Destination;
import com.raoulvdberge.refinedpipes.network.pipe.DestinationType;
import com.raoulvdberge.refinedpipes.network.pipe.Pipe;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class Network {
    protected final NetworkGraph graph = new NetworkGraph(this);
    private final String id;
    private BlockPos originPos;
    private boolean didDoInitialScan;

    public Network(BlockPos originPos, String id) {
        this.id = id;
        this.originPos = originPos;
    }

    public void setOriginPos(BlockPos originPos) {
        this.originPos = originPos;
    }

    public String getId() {
        return this.id;
    }

    public NetworkGraphScannerResult scanGraph(World world, BlockPos pos) {
        return this.graph.scan(world, pos);
    }

    public List<Destination> getDestinations(DestinationType type) {
        return this.graph.getDestinations(type);
    }

    public CompoundNBT writeToNbt(CompoundNBT tag) {
        tag.func_74778_a("id", this.id);
        tag.func_74772_a("origin", this.originPos.func_218275_a());
        return tag;
    }

    public void update(World world) {
        if (!this.didDoInitialScan) {
            this.didDoInitialScan = true;
            this.scanGraph(world, this.originPos);
        }
        this.graph.getPipes().forEach(Pipe::update);
    }

    public Pipe getPipe(BlockPos pos) {
        return this.graph.getPipes().stream().filter(p -> p.getPos().equals((Object)pos)).findFirst().orElse(null);
    }

    public abstract void onMergedWith(Network var1);

    public abstract ResourceLocation getType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Network network = (Network)o;
        return this.id.equals(network.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

