/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.items.upgrade;

import com.direwolf20.mininggadgets.common.Config;
import com.direwolf20.mininggadgets.common.items.UpgradeCard;

public enum Upgrade {
    EMPTY("empty", 0, false),
    SILK("silk", (int)((Integer)Config.UPGRADECOST_SILKTOUCH.get()), true),
    VOID_JUNK("void_junk", (Integer)Config.UPGRADECOST_VOID.get()),
    MAGNET("magnet", (Integer)Config.UPGRADECOST_MAGNET.get()),
    FREEZING("freezing", 0),
    THREE_BY_THREE("three_by_three", 0, false),
    LIGHT_PLACER("light_placer", 0),
    FORTUNE_1("fortune_1", 1, (Integer)Config.UPGRADECOST_FORTUNE1.get(), true),
    FORTUNE_2("fortune_2", 2, (Integer)Config.UPGRADECOST_FORTUNE2.get(), true),
    FORTUNE_3("fortune_3", 3, (Integer)Config.UPGRADECOST_FORTUNE3.get(), true),
    BATTERY_1("battery_1", 1, 0),
    BATTERY_2("battery_2", 2, 0),
    BATTERY_3("battery_3", 3, 0),
    RANGE_1("range_1", 1, 0),
    RANGE_2("range_2", 2, 0),
    RANGE_3("range_3", 3, 0),
    EFFICIENCY_1("efficiency_1", 1, (Integer)Config.UPGRADECOST_EFFICIENCY1.get(), true),
    EFFICIENCY_2("efficiency_2", 2, (Integer)Config.UPGRADECOST_EFFICIENCY2.get(), true),
    EFFICIENCY_3("efficiency_3", 3, (Integer)Config.UPGRADECOST_EFFICIENCY3.get(), true),
    EFFICIENCY_4("efficiency_4", 4, (Integer)Config.UPGRADECOST_EFFICIENCY4.get(), true),
    EFFICIENCY_5("efficiency_5", 5, (Integer)Config.UPGRADECOST_EFFICIENCY5.get(), true);

    private String name;
    private String baseName;
    private UpgradeCard card;
    private int tier;
    private int costPerBlock;
    private boolean active = true;
    private boolean isToggleable;
    private String tooltop;

    private Upgrade(String name, int tier, int costPerBlock, boolean isToggleable) {
        this.name = name;
        this.tier = tier;
        this.costPerBlock = costPerBlock;
        this.card = new UpgradeCard(this, name.equals("empty") ? 64 : 1);
        this.baseName = tier == -1 ? name : name.substring(0, name.lastIndexOf(95));
        this.isToggleable = isToggleable;
        this.tooltop = "tooltop.mininggadgets." + this.baseName;
    }

    private Upgrade(String name, int tier, int costPerBlock) {
        this(name, tier, costPerBlock, false);
    }

    private Upgrade(String name, int costPerBlock) {
        this(name, -1, costPerBlock, true);
    }

    private Upgrade(String name, int costPerBlock, boolean isToggleable) {
        this(name, -1, costPerBlock, isToggleable);
    }

    public String getName() {
        return this.name;
    }

    public UpgradeCard getCard() {
        return this.card;
    }

    public int getTier() {
        return this.tier;
    }

    public int getCostPerBlock() {
        return this.costPerBlock;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getLocal() {
        return String.format("item.mininggadgets.upgrade_%s", this.getName());
    }

    public String getLocalReplacement() {
        return "mininggadgets.upgrade.replacement";
    }

    public boolean hasTier() {
        return this.tier != -1;
    }

    public boolean isEnabled() {
        return this.active;
    }

    public void setEnabled(boolean active) {
        this.active = active;
    }

    public boolean isToggleable() {
        return this.isToggleable;
    }

    public String getTooltop() {
        return this.tooltop;
    }

    public boolean lazyIs(Upgrade upgrade) {
        return this.getBaseName().equals(upgrade.getBaseName());
    }
}

