/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.omegacraft;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.omegacraft.OmegaCraftHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"omegacraft"})
public class OmegaCraftCompatModule
implements IModule {
    private static final Set<String> TO_DUST_BLACKLIST = new TreeSet<String>(Arrays.asList("aluminum", "bronze", "copper", "electrum", "gold", "iron", "lead", "magmite", "silver", "steel", "tin"));
    private static final Set<String> TO_PLATE_BLACKLIST = new TreeSet<String>(Arrays.asList("aluminum", "bronze", "cave_magmite", "copper", "electrum", "gold", "iron", "lead", "magmite", "silver", "steel", "tin"));
    private static final Set<String> COMPACT_TO_BLOCK_BLACKLIST = new TreeSet<String>(Arrays.asList("aluminum", "bronze", "cave_magmite", "copper", "electrum", "gold", "iron", "lead", "magmite", "silver", "steel", "tin"));
    private static final Set<String> COMPACT_TO_INGOT_BLACKLIST = new TreeSet<String>(Arrays.asList("aluminum", "bronze", "cave_magmite", "copper", "electrum", "gold", "iron", "lead", "magmite", "silver", "steel", "tin"));
    private boolean recipeRegistered = false;

    @Override
    public String getName() {
        return "omegacraft_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void onRecipeInjectComplete(IModuleData moduleData, IResourceManager resourceManager) {
        if (!this.recipeRegistered) {
            ApiImpl api = ApiImpl.INSTANCE;
            OmegaCraftHelper helper = OmegaCraftHelper.INSTANCE;
            MiscHelper miscHelper = MiscHelper.INSTANCE;
            for (IMaterial material : moduleData.getMaterials()) {
                ResourceLocation materialLocation;
                MaterialType type = material.getType();
                if (!ArrayUtils.contains((Object[])MaterialType.INGOTS, (Object)((Object)type))) continue;
                if (!TO_DUST_BLACKLIST.contains(material.getName())) {
                    materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                    ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
                    if (((JAOPCAApi)api).getItemTags().contains(dustLocation)) {
                        helper.registerCrusherRecipe(materialLocation, 1, dustLocation, 1);
                    }
                }
                if (!TO_PLATE_BLACKLIST.contains(material.getName())) {
                    materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                    ResourceLocation plateLocation = miscHelper.getTagLocation("plates", material.getName());
                    if (((JAOPCAApi)api).getItemTags().contains(plateLocation)) {
                        helper.registerPlateFormerRecipe(materialLocation, 1, plateLocation, 1);
                    }
                }
                if (!COMPACT_TO_BLOCK_BLACKLIST.contains(material.getName())) {
                    materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                    ResourceLocation blockLocation = miscHelper.getTagLocation("blocks", material.getName());
                    if (((JAOPCAApi)api).getItemTags().contains(blockLocation)) {
                        helper.registerBlockCompactorRecipe(materialLocation, 9, blockLocation, 1);
                    }
                }
                if (COMPACT_TO_INGOT_BLACKLIST.contains(material.getName())) continue;
                ResourceLocation plateLocation = miscHelper.getTagLocation("plates", material.getName());
                ResourceLocation materialLocation2 = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                if (!((JAOPCAApi)api).getItemTags().contains(plateLocation)) continue;
                helper.registerBlockCompactorRecipe(plateLocation, 1, materialLocation2, 1);
            }
            this.recipeRegistered = true;
        }
    }
}

