/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.flux.recipes;

import com.google.common.base.Strings;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import szewek.flux.recipe.CompactingRecipe;
import szewek.flux.recipe.MachineRecipeSerializer;
import thelm.jaopca.compat.flux.FluxHelper;
import thelm.jaopca.utils.MiscHelper;

public class CompactingRecipeSupplier
implements Supplier<CompactingRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object input;
    public final int inputCount;
    public final Object secondInput;
    public final int secondInputCount;
    public final Object output;
    public final int outputCount;
    public final float experience;
    public final int time;

    public CompactingRecipeSupplier(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, float experience, int time) {
        this(key, "", input, inputCount, Ingredient.field_193370_a, 0, output, outputCount, experience, time);
    }

    public CompactingRecipeSupplier(ResourceLocation key, String group, Object input, int inputCount, Object output, int outputCount, float experience, int time) {
        this(key, group, input, inputCount, Ingredient.field_193370_a, 0, output, outputCount, experience, time);
    }

    public CompactingRecipeSupplier(ResourceLocation key, Object input, int inputCount, Object secondInput, int secondInputCount, Object output, int outputCount, float experience, int time) {
        this(key, "", input, inputCount, secondInput, secondInputCount, output, outputCount, experience, time);
    }

    public CompactingRecipeSupplier(ResourceLocation key, String group, Object input, int inputCount, Object secondInput, int secondInputCount, Object output, int outputCount, float experience, int time) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.input = input;
        this.inputCount = inputCount;
        this.secondInput = secondInput;
        this.secondInputCount = secondInputCount;
        this.output = output;
        this.outputCount = outputCount;
        this.experience = experience;
        this.time = time;
    }

    @Override
    public CompactingRecipe get() {
        ItemStack stack;
        MachineRecipeSerializer.Builder builder = new MachineRecipeSerializer.Builder();
        Ingredient ing = FluxHelper.INSTANCE.getCountedIngredient(this.input, this.inputCount);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        builder.ingredients.add((Object)ing);
        if (this.secondInputCount > 0) {
            Ingredient secondIng = FluxHelper.INSTANCE.getCountedIngredient(this.secondInput, this.secondInputCount);
            if (secondIng.func_203189_d()) {
                LOGGER.warn("Empty ingredient in recipe {}: {}", (Object)this.key, (Object)secondIng);
            } else {
                builder.ingredients.add((Object)secondIng);
            }
        }
        if ((stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount)).func_190926_b()) {
            LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, this.output);
        }
        builder.result = stack;
        builder.experience = this.experience;
        builder.process = this.time;
        return new CompactingRecipe(this.key, this.group, builder);
    }
}

