/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.cfd;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.lex.cfd.CobbleForDays;
import net.minecraftforge.lex.cfd.Config;

public class CobbleGenTile
extends TileEntity
implements ITickableTileEntity {
    private final ConfigCache config;
    private final LazyOptional<IItemHandler> inventory = LazyOptional.of(() -> new Inventory());
    private LazyOptional<IItemHandler> cache = null;
    private int count = 0;
    private int timer = 20;
    private int configTimer = 200;

    public CobbleGenTile(Config.Server.Tier tier, TileEntityType<?> tileType) {
        super(tileType);
        this.config = new ConfigCache(tier);
        this.timer = (Integer)tier.interval.get();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        this.inventory.invalidate();
        super.func_145843_s();
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.count = nbt.func_74762_e("count");
        this.timer = nbt.func_74762_e("timer");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("count", this.count);
        nbt.func_74768_a("timer", this.timer);
        return nbt;
    }

    public void func_73660_a() {
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.timer-- <= 0) {
            this.count += this.config.count;
            this.timer = this.config.interval;
            if (this.count > this.config.max) {
                this.count = this.config.max;
            }
            if (this.count < 0) {
                this.count = 0;
            }
            this.func_70296_d();
        }
        if (this.config.pushes && this.count > 0 && this.getCache().isPresent()) {
            this.push();
        }
        if (this.configTimer-- <= 0) {
            this.config.update();
            this.configTimer = 200;
        }
    }

    public void updateCache() {
        TileEntity tileEntity;
        TileEntity tileEntity2 = tileEntity = this.field_145850_b != null ? this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a()) : null;
        if (tileEntity != null) {
            LazyOptional lazyOptional = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN);
            if (lazyOptional.isPresent()) {
                if (this.cache != lazyOptional) {
                    this.cache = lazyOptional;
                    this.cache.addListener(l -> this.updateCache());
                }
            } else {
                this.cache = LazyOptional.empty();
            }
        } else {
            this.cache = LazyOptional.empty();
        }
    }

    private LazyOptional<IItemHandler> getCache() {
        if (this.cache == null) {
            this.updateCache();
        }
        return this.cache;
    }

    private void push() {
        ItemStack stack = new ItemStack((IItemProvider)Items.field_221585_m, this.count);
        ItemStack result = (ItemStack)this.getCache().map(iItemHandler -> ItemHandlerHelper.insertItemStacked((IItemHandler)iItemHandler, (ItemStack)stack, (boolean)false)).orElse((Object)stack);
        if (result.func_190926_b()) {
            this.count = 0;
            this.func_70296_d();
        } else if (result.func_190916_E() != this.count) {
            this.count = result.func_190916_E();
            this.func_70296_d();
        }
    }

    public static CobbleGenTile create(int tier) {
        switch (tier) {
            case 1: {
                return new CobbleGenTile(Config.SERVER.tier1, (TileEntityType)CobbleForDays.TIER1_TILE.get());
            }
            case 2: {
                return new CobbleGenTile(Config.SERVER.tier2, (TileEntityType)CobbleForDays.TIER2_TILE.get());
            }
            case 3: {
                return new CobbleGenTile(Config.SERVER.tier3, (TileEntityType)CobbleForDays.TIER3_TILE.get());
            }
            case 4: {
                return new CobbleGenTile(Config.SERVER.tier4, (TileEntityType)CobbleForDays.TIER4_TILE.get());
            }
            case 5: {
                return new CobbleGenTile(Config.SERVER.tier5, (TileEntityType)CobbleForDays.TIER5_TILE.get());
            }
        }
        throw new IllegalArgumentException("Unknown Tier: " + tier);
    }

    private class Inventory
    implements IItemHandler {
        private final ItemStack stack = new ItemStack((IItemProvider)Items.field_221585_m, 0);

        private Inventory() {
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return this.stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (CobbleGenTile.this.count == 0 || amount == 0) {
                return ItemStack.field_190927_a;
            }
            int ret = Math.min(CobbleGenTile.this.count, amount);
            if (!simulate) {
                CobbleGenTile.this.count = CobbleGenTile.this.count - ret;
                CobbleGenTile.this.func_70296_d();
            }
            return new ItemStack((IItemProvider)Items.field_221585_m, ret);
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }
    }

    private static class ConfigCache {
        private final Config.Server.Tier tier;
        private int interval;
        private int count;
        private int max;
        private boolean pushes;

        private ConfigCache(Config.Server.Tier tier) {
            this.tier = tier;
            this.update();
        }

        private void update() {
            this.interval = (Integer)this.tier.interval.get();
            this.count = (Integer)this.tier.count.get();
            this.max = (Integer)this.tier.max.get();
            this.pushes = (Boolean)this.tier.pushes.get();
        }
    }
}

