/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.serialization;

import com.davenonymous.libnonymous.render.MultiblockBlockModel;
import com.davenonymous.libnonymous.utils.BlockStateSerializationHelper;
import com.davenonymous.libnonymous.utils.Logz;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class MultiBlockModelSerializer
implements JsonDeserializer<MultiblockBlockModel> {
    public MultiblockBlockModel deserialize(JsonElement root, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!root.isJsonObject()) {
            return null;
        }
        JsonObject rootObj = root.getAsJsonObject();
        int version = rootObj.has("version") ? rootObj.get("version").getAsInt() : 1;
        switch (version) {
            case 1: {
                Logz.warn("Invalid version in shape file: '%s', skipping shape! Shape files below v3 are not supported!", rootObj.get("version"));
                return null;
            }
            case 2: {
                Logz.warn("Invalid version in shape file: '%s', skipping shape! Shape files below v3 are not supported!", rootObj.get("version"));
                return null;
            }
            case 3: {
                return this.deserializeV3(rootObj, typeOfT, context);
            }
        }
        Logz.warn("Invalid version in shape file: '%s', skipping shape! Maybe the shape file is from a newer mod version?", rootObj.get("version"));
        return null;
    }

    private Map<String, BlockState> getReferenceMapV3(JsonObject jsonRefMap) {
        HashMap<String, BlockState> refMap = new HashMap<String, BlockState>();
        for (Map.Entry jsonRefEntry : jsonRefMap.entrySet()) {
            JsonObject jsonBlockInfo = ((JsonElement)jsonRefEntry.getValue()).getAsJsonObject();
            BlockState state = BlockStateSerializationHelper.deserializeBlockState(jsonBlockInfo);
            refMap.put((String)jsonRefEntry.getKey(), state);
        }
        return refMap;
    }

    private boolean hasUnknownBlocksInMap(JsonObject jsonRefMap) {
        for (Map.Entry jsonRefEntry : jsonRefMap.entrySet()) {
            JsonObject jsonBlockInfo = ((JsonElement)jsonRefEntry.getValue()).getAsJsonObject();
            if (BlockStateSerializationHelper.isValidBlockState(jsonBlockInfo)) continue;
            return true;
        }
        return false;
    }

    public MultiblockBlockModel deserializeV3(JsonObject root, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!root.has("type")) {
            Logz.warn("Missing type name in multiblockmodel json", new Object[0]);
            return null;
        }
        ResourceLocation treeType = new ResourceLocation(root.get("type").getAsString());
        if (this.hasUnknownBlocksInMap(root.getAsJsonObject("ref"))) {
            return null;
        }
        Map<String, BlockState> refMap = this.getReferenceMapV3(root.getAsJsonObject("ref"));
        HashMap<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
        JsonArray jsonBlocks = root.getAsJsonArray("shape");
        int x = jsonBlocks.size() - 1;
        for (JsonElement zSliceElement : jsonBlocks) {
            int y = zSliceElement.getAsJsonArray().size() - 1;
            for (JsonElement ySliceElement : zSliceElement.getAsJsonArray()) {
                for (int z = 0; z < ySliceElement.getAsString().length(); ++z) {
                    String ref = ySliceElement.getAsString().charAt(z) + "";
                    if (ref.equals(" ")) continue;
                    if (!refMap.containsKey(ref)) {
                        Logz.warn("Shape-Entry is using an unknown block reference '%s'! Skipping shape!", ref);
                        return null;
                    }
                    blocks.put(new BlockPos(x, y, z), refMap.get(ref));
                }
                --y;
            }
            --x;
        }
        MultiblockBlockModel result = new MultiblockBlockModel(treeType);
        result.setBlocks(blocks);
        return result;
    }
}

