/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import mcjty.incontrol.InControl;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;

public class CmdKillMobs
implements Command<CommandSource> {
    private static final CmdKillMobs CMD = new CmdKillMobs();

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"kill").requires(cs -> cs.func_197034_c(2))).then(Commands.func_197056_a((String)"type", (ArgumentType)StringArgumentType.word()).executes((Command)CMD));
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        if (player != null) {
            String type = (String)context.getArgument("type", String.class);
            if (type == null || type.trim().isEmpty()) {
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Use 'all', 'passive', 'hostile' or name of the mob followed by optional dimension id"));
                InControl.setup.getLogger().error("Use 'all', 'passive', 'hostile', 'entity' or name of the mob followed by optional dimension id");
                return 0;
            }
            DimensionType dimension = player.func_130014_f_().func_201675_m().func_186058_p();
            boolean all = "all".equals(type);
            boolean passive = "passive".equals(type);
            boolean hostile = "hostile".equals(type);
            boolean entity = "entity".equals(type);
            ServerWorld worldServer = player.func_130014_f_().func_73046_m().func_71218_a(dimension);
            List entities = worldServer.func_217482_a(null, input -> {
                if (all) {
                    return !(input instanceof PlayerEntity);
                }
                if (passive) {
                    return input instanceof AnimalEntity && !(input instanceof IMob);
                }
                if (hostile) {
                    return input instanceof IMob;
                }
                if (entity) {
                    return !(input instanceof AnimalEntity) && !(input instanceof PlayerEntity);
                }
                String id = input.func_200600_R().getRegistryName().toString();
                return type.equals(id);
            });
            for (Entity e : entities) {
                worldServer.func_217467_h(e);
            }
            player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "Removed " + entities.size() + " entities!"));
        }
        return 0;
    }
}

