/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Optional;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.GuiTools;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockTools;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridInventory;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.CraftingRecipe;
import mcjty.rftoolsstorage.craftinggrid.PacketGridToServer;
import mcjty.rftoolsstorage.setup.CommandHandler;
import mcjty.rftoolsstorage.setup.RFToolsStorageMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class GuiCraftingGrid {
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsstorage", "textures/gui/craftinggrid.png");
    protected Window craftWindow;
    private Button craft1Button;
    private Button craft4Button;
    private Button craft8Button;
    private Button craftSButton;
    private Button storeButton;
    private WidgetList recipeList;
    private Minecraft mc;
    private GenericGuiContainer<?, ?> gui;
    private CraftingGridProvider provider;
    private BlockPos pos;
    private DimensionType type;
    public static int[] testResultFromServer = null;
    private int lastTestAmount = -2;
    private int lastTestTimer = 0;

    public void initGui(ModBase modBase, SimpleChannel network, Minecraft mc, GenericGuiContainer<?, ?> gui, BlockPos pos, DimensionType type, CraftingGridProvider provider, int guiLeft, int guiTop, int xSize, int ySize) {
        this.mc = mc;
        this.gui = gui;
        this.provider = provider;
        this.pos = pos;
        this.type = type;
        this.recipeList = Widgets.list((int)5, (int)5, (int)56, (int)102);
        this.recipeList.event((SelectionEvent)new DefaultSelectionEvent(){

            public void doubleClick(int index) {
                GuiCraftingGrid.this.selectRecipe();
            }
        });
        this.craft1Button = (Button)((Button)Widgets.button((int)29, (int)183, (int)14, (int)10, (String)"1").channel("craft1")).tooltips(new String[]{"Craft one"});
        this.craft4Button = (Button)((Button)Widgets.button((int)45, (int)183, (int)14, (int)10, (String)"4").channel("craft4")).tooltips(new String[]{"Craft four"});
        this.craft8Button = (Button)((Button)Widgets.button((int)29, (int)195, (int)14, (int)10, (String)"8").channel("craft8")).tooltips(new String[]{"Craft eight"});
        this.craftSButton = (Button)((Button)Widgets.button((int)45, (int)195, (int)14, (int)10, (String)"*").channel("craftstack")).tooltips(new String[]{"Craft a stack"});
        this.storeButton = (Button)((Button)Widgets.button((int)5, (int)109, (int)56, (int)14, (String)"Store").channel("store")).tooltips(new String[]{"Store the current recipe"});
        Panel sidePanel = (Panel)Widgets.positional().children(new Widget[]{this.craft1Button, this.craft4Button, this.craft8Button, this.craftSButton, this.storeButton, this.recipeList});
        int sideLeft = guiLeft - CraftingGridInventory.GRID_WIDTH - 2;
        int sideTop = guiTop;
        sidePanel.bounds(sideLeft, sideTop, CraftingGridInventory.GRID_WIDTH, CraftingGridInventory.GRID_HEIGHT);
        sidePanel.background(iconLocation);
        this.craftWindow = new Window(gui, (AbstractContainerWidget)sidePanel);
        this.craftWindow.event("craft1", (source, params) -> this.craft(1));
        this.craftWindow.event("craft4", (source, params) -> this.craft(4));
        this.craftWindow.event("craft8", (source, params) -> this.craft(8));
        this.craftWindow.event("craftstack", (source, params) -> this.craft(-1));
        this.craftWindow.event("store", (source, params) -> this.store());
    }

    public Window getWindow() {
        return this.craftWindow;
    }

    private void craft(int n) {
        RFToolsStorageMessages.sendToServer("craftFromGrid", TypedMap.builder().put(CommandHandler.PARAM_COUNT, (Object)n).put(CommandHandler.PARAM_TEST, (Object)false).put(CommandHandler.PARAM_POS, (Object)this.pos).put(CommandHandler.PARAM_DIMENSION, (Object)this.type));
    }

    private void testCraft(int n) {
        if (this.lastTestAmount != n || this.lastTestTimer <= 0) {
            RFToolsStorageMessages.sendToServer("craftFromGrid", TypedMap.builder().put(CommandHandler.PARAM_COUNT, (Object)n).put(CommandHandler.PARAM_TEST, (Object)true).put(CommandHandler.PARAM_POS, (Object)this.pos).put(CommandHandler.PARAM_DIMENSION, (Object)this.type));
            this.lastTestAmount = n;
            this.lastTestTimer = 20;
        }
        --this.lastTestTimer;
    }

    private void store() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        this.provider.storeRecipe(selected);
        RFToolsStorageMessages.INSTANCE.sendToServer((Object)new PacketGridToServer(this.pos, this.type, this.provider.getCraftingGrid()));
    }

    private void selectRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        this.provider.getCraftingGrid().selectRecipe(selected);
        RFToolsStorageMessages.INSTANCE.sendToServer((Object)new PacketGridToServer(this.pos, this.type, this.provider.getCraftingGrid()));
    }

    private void populateList() {
        this.recipeList.removeChildren();
        for (int i = 0; i < 6; ++i) {
            CraftingRecipe recipe = this.provider.getCraftingGrid().getRecipe(i);
            this.addRecipeLine(recipe.getResult());
        }
    }

    public void draw() {
        int selected = this.recipeList.getSelected();
        this.storeButton.enabled(selected != -1);
        this.populateList();
        this.testRecipe();
        int x = GuiTools.getRelativeX(this.gui);
        int y = GuiTools.getRelativeY(this.gui);
        Widget widget = this.craftWindow.getToplevel().getWidgetAtPosition((double)x, (double)y);
        if (widget == this.craft1Button) {
            this.testCraft(1);
        } else if (widget == this.craft4Button) {
            this.testCraft(4);
        } else if (widget == this.craft8Button) {
            this.testCraft(8);
        } else if (widget == this.craftSButton) {
            this.testCraft(-1);
        } else {
            testResultFromServer = null;
            this.lastTestAmount = -2;
            this.lastTestTimer = 0;
        }
        this.craftWindow.draw();
        if (testResultFromServer != null) {
            Slot slot;
            GlStateManager.func_227626_N_();
            GlStateManager.func_227688_c_((float)this.gui.getGuiLeft(), (float)this.gui.getGuiTop(), (float)0.0f);
            if (testResultFromServer[9] > 0 && (slot = this.gui.func_212873_a_().func_75139_a(0)) != null) {
                GlStateManager.func_227668_a_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                int xPos = slot.field_75223_e;
                int yPos = slot.field_75221_f;
                Screen.fill((int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)-65536);
            }
            for (int i = 0; i < 9; ++i) {
                Slot slot2;
                if (testResultFromServer[i] <= 0 || (slot2 = this.gui.func_212873_a_().func_75139_a(1 + i)) == null) continue;
                GlStateManager.func_227668_a_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                int xPos = slot2.field_75223_e;
                int yPos = slot2.field_75221_f;
                Screen.fill((int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)-65536);
            }
            GlStateManager.func_227627_O_();
        }
    }

    private void testRecipe() {
        CraftingInventory inv = new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(PlayerEntity var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inv.func_70299_a(i, this.provider.getCraftingGrid().getCraftingGridInventory().getStackInSlot(i + 1));
        }
        Optional<ICraftingRecipe> recipe = CraftingRecipe.findRecipe((World)this.mc.field_71441_e, inv);
        ItemStack newResult = recipe.map(r -> r.func_77572_b((IInventory)inv)).orElse(ItemStack.field_190927_a);
        this.provider.getCraftingGrid().getCraftingGridInventory().setStackInSlot(0, newResult);
    }

    private void addRecipeLine(ItemStack craftingResult) {
        String readableName = BlockTools.getReadableName((ItemStack)craftingResult);
        int color = StyleConfig.colorTextInListNormal;
        if (craftingResult.func_190926_b()) {
            readableName = "<recipe>";
            color = -11513776;
        }
        Panel panel = (Panel)Widgets.positional().children(new Widget[]{new BlockRender().renderItem((Object)craftingResult).hint(0, 0, 18, 18), ((Label)((Label)Widgets.label((String)readableName).color(color)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).hint(20, 0, 30, 18)});
        this.recipeList.children(new Widget[]{panel});
    }
}

