/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.common;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.OreBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.client.CreativeTab;
import slimeknights.mantle.common.IRegisterUtil;
import slimeknights.tmechworks.client.gui.DisguiseScreen;
import slimeknights.tmechworks.client.gui.DrawbridgeScreen;
import slimeknights.tmechworks.common.blocks.DrawbridgeBlock;
import slimeknights.tmechworks.common.blocks.FirestarterBlock;
import slimeknights.tmechworks.common.blocks.MetalBlock;
import slimeknights.tmechworks.common.blocks.tileentity.DrawbridgeTileEntity;
import slimeknights.tmechworks.common.blocks.tileentity.FirestarterTileEntity;
import slimeknights.tmechworks.common.config.MechworksConfig;
import slimeknights.tmechworks.common.inventory.DisguiseContainer;
import slimeknights.tmechworks.common.inventory.DrawbridgeContainer;
import slimeknights.tmechworks.common.items.MachineUpgradeItem;
import slimeknights.tmechworks.common.items.MechworksBlockItem;
import slimeknights.tmechworks.common.items.MechworksBookItem;
import slimeknights.tmechworks.common.items.MechworksItem;
import slimeknights.tmechworks.common.worldgen.MechworksWorld;

public class MechworksContent
implements IRegisterUtil {
    private Logger log = LogManager.getLogger((String)"tmechworks.content");
    public static CreativeTab tabMechworks = new CreativeTab("TinkersMechworks", new ItemStack((IItemProvider)net.minecraft.item.Items.field_196196_el));

    public String getModId() {
        return "tmechworks";
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        this.register(registry, (IForgeRegistryEntry)new OreBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(3.0f).harvestTool(ToolType.PICKAXE).harvestLevel(ItemTier.IRON.func_200925_d())), "aluminum_ore");
        this.register(registry, (IForgeRegistryEntry)new OreBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(3.0f).harvestTool(ToolType.PICKAXE).harvestLevel(ItemTier.IRON.func_200925_d())), "copper_ore");
        this.register(registry, (IForgeRegistryEntry)new MetalBlock(), "aluminum_block");
        this.register(registry, (IForgeRegistryEntry)new MetalBlock(), "copper_block");
        this.register(registry, (IForgeRegistryEntry)new FirestarterBlock(), "firestarter");
        this.register(registry, (IForgeRegistryEntry)new DrawbridgeBlock(), "drawbridge");
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        this.register(registry, (IForgeRegistryEntry)new MechworksBookItem(), "book");
        this.registerBlockItem((IForgeRegistry<Item>)registry, (Block)Blocks.aluminum_ore);
        this.registerBlockItem((IForgeRegistry<Item>)registry, (Block)Blocks.copper_ore);
        this.registerBlockItem((IForgeRegistry<Item>)registry, Blocks.copper_block);
        this.registerBlockItem((IForgeRegistry<Item>)registry, Blocks.aluminum_block);
        this.register(registry, (IForgeRegistryEntry)new MechworksItem(), "copper_ingot");
        this.register(registry, (IForgeRegistryEntry)new MechworksItem(), "aluminum_ingot");
        this.register(registry, (IForgeRegistryEntry)new MechworksItem(), "copper_nugget");
        this.register(registry, (IForgeRegistryEntry)new MechworksItem(), "aluminum_nugget");
        this.registerBlockItem((IForgeRegistry<Item>)registry, (Block)Blocks.firestarter);
        this.registerBlockItem((IForgeRegistry<Item>)registry, (Block)Blocks.drawbridge);
        this.register(registry, (IForgeRegistryEntry)new MechworksItem(), "upgrade_blank");
        this.register(registry, (IForgeRegistryEntry)new MachineUpgradeItem(stats -> {
            stats.isAdvanced = true;
        }), "upgrade_drawbridge_advanced");
        this.register(registry, (IForgeRegistryEntry)new MachineUpgradeItem(stats -> stats.extendLength += ((Integer)MechworksConfig.DRAWBRIDGE.extendUpgradeValue.get()).intValue()).setTooltipFormatSupplier(() -> new Object[]{MechworksConfig.DRAWBRIDGE.extendUpgradeValue.get()}), "upgrade_drawbridge_distance");
        this.register(registry, (IForgeRegistryEntry)new MachineUpgradeItem(stats -> {
            stats.extendDelay = (float)((double)stats.extendDelay - (Double)MechworksConfig.DRAWBRIDGE.speedUpgradeValue.get());
        }).setTooltipFormatSupplier(() -> new Object[]{MechworksConfig.DRAWBRIDGE.speedUpgradeValue.get()}), "upgrade_speed");
    }

    @SubscribeEvent
    public void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        this.registerTE(registry, FirestarterTileEntity::new, "firestarter", new Block[]{Blocks.firestarter});
        this.registerTE(registry, DrawbridgeTileEntity::new, "drawbridge", new Block[]{Blocks.drawbridge});
    }

    @SubscribeEvent
    public void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        this.register(registry, (IForgeRegistryEntry)IForgeContainerType.create(DisguiseContainer::factory), "disguise");
        this.register(registry, (IForgeRegistryEntry)IForgeContainerType.create(DrawbridgeContainer::factory), "drawbridge");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerScreenFactories() {
        ScreenManager.func_216911_a(Containers.disguise, DisguiseScreen::create);
        ScreenManager.func_216911_a(Containers.drawbridge, DrawbridgeScreen::create);
    }

    public void preInit(FMLCommonSetupEvent event) {
    }

    public void init(InterModEnqueueEvent event) {
    }

    public void postInit(InterModProcessEvent event) {
        tabMechworks.setDisplayIcon(new ItemStack((IItemProvider)Items.book));
        MechworksWorld.registerWorldGeneration();
    }

    public BlockItem registerBlockItem(IForgeRegistry<Item> registry, Block block) {
        MechworksBlockItem itemBlock = new MechworksBlockItem(block, new Item.Properties().func_200916_a((ItemGroup)tabMechworks));
        return (BlockItem)this.register(registry, (IForgeRegistryEntry)itemBlock, block.getRegistryName());
    }

    @Nonnull
    private static <T> T empty() {
        return null;
    }

    static /* synthetic */ Object access$000() {
        return MechworksContent.empty();
    }

    @ObjectHolder(value="tmechworks")
    public static class Containers {
        public static final ContainerType<DisguiseContainer> disguise = (ContainerType)MechworksContent.access$000();
        public static final ContainerType<DrawbridgeContainer> drawbridge = (ContainerType)MechworksContent.access$000();
    }

    @ObjectHolder(value="tmechworks")
    public static class TileEntities {
        public static final TileEntityType<?> firestarter = (TileEntityType)MechworksContent.access$000();
        public static final TileEntityType<?> drawbridge = (TileEntityType)MechworksContent.access$000();
    }

    @ObjectHolder(value="tmechworks")
    public static class Items {
        public static final MechworksBookItem book = (MechworksBookItem)((Object)MechworksContent.access$000());
        public static final MechworksItem upgrade_blank = (MechworksItem)((Object)MechworksContent.access$000());
        public static final MachineUpgradeItem upgrade_drawbridge_advanced = (MachineUpgradeItem)((Object)MechworksContent.access$000());
        public static final MachineUpgradeItem upgrade_drawbridge_distance = (MachineUpgradeItem)((Object)MechworksContent.access$000());
        public static final MachineUpgradeItem upgrade_speed = (MachineUpgradeItem)((Object)MechworksContent.access$000());
    }

    @ObjectHolder(value="tmechworks")
    public static class Blocks {
        public static final OreBlock aluminum_ore = (OreBlock)MechworksContent.access$000();
        public static final OreBlock copper_ore = (OreBlock)MechworksContent.access$000();
        public static final MetalBlock aluminum_block = (MetalBlock)((Object)MechworksContent.access$000());
        public static final MetalBlock copper_block = (MetalBlock)((Object)MechworksContent.access$000());
        public static final FirestarterBlock firestarter = (FirestarterBlock)MechworksContent.access$000();
        public static final DrawbridgeBlock drawbridge = (DrawbridgeBlock)MechworksContent.access$000();
    }
}

