/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import javax.annotation.Nullable;
import net.blay09.mods.craftingtweaks.CompressType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class KeyBindings {
    public static final KeyBinding keyRotate = new KeyBinding("key.craftingtweaks.rotate", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, InputMappings.Type.KEYSYM, InputMappings.field_197958_a.func_197937_c(), "key.categories.craftingtweaks");
    public static final KeyBinding keyRotateCounterClockwise = new KeyBinding("key.craftingtweaks.rotate_counter_clockwise", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, InputMappings.Type.KEYSYM, InputMappings.field_197958_a.func_197937_c(), "key.categories.craftingtweaks");
    public static final KeyBinding keyBalance = new KeyBinding("key.craftingtweaks.balance", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, InputMappings.Type.KEYSYM, InputMappings.field_197958_a.func_197937_c(), "key.categories.craftingtweaks");
    public static final KeyBinding keySpread = new KeyBinding("key.craftingtweaks.spread", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, InputMappings.Type.KEYSYM, InputMappings.field_197958_a.func_197937_c(), "key.categories.craftingtweaks");
    public static final KeyBinding keyClear = new KeyBinding("key.craftingtweaks.clear", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, InputMappings.Type.KEYSYM, InputMappings.field_197958_a.func_197937_c(), "key.categories.craftingtweaks");
    public static final KeyBinding keyForceClear = new KeyBinding("key.craftingtweaks.force_clear", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, InputMappings.Type.KEYSYM, InputMappings.field_197958_a.func_197937_c(), "key.categories.craftingtweaks");
    public static final KeyBinding keyToggleButtons = new KeyBinding("key.craftingtweaks.toggleButtons", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, InputMappings.Type.KEYSYM, InputMappings.field_197958_a.func_197937_c(), "key.categories.craftingtweaks");
    public static final KeyBinding keyCompressOne = new KeyBinding("key.craftingtweaks.compressOne", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.CONTROL, InputMappings.func_197954_a((int)75, (int)0), "key.categories.craftingtweaks");
    public static final KeyBinding keyCompressStack = new KeyBinding("key.craftingtweaks.compressStack", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, InputMappings.func_197954_a((int)75, (int)0), "key.categories.craftingtweaks");
    public static final KeyBinding keyCompressAll = new KeyBinding("key.craftingtweaks.compressAll", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.SHIFT, InputMappings.func_197954_a((int)75, (int)0), "key.categories.craftingtweaks");
    public static final KeyBinding keyDecompressOne = new KeyBinding("key.craftingtweaks.decompressOne", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, InputMappings.Type.KEYSYM, InputMappings.field_197958_a.func_197937_c(), "key.categories.craftingtweaks");
    public static final KeyBinding keyDecompressStack = new KeyBinding("key.craftingtweaks.decompressStack", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, InputMappings.Type.KEYSYM, InputMappings.field_197958_a.func_197937_c(), "key.categories.craftingtweaks");
    public static final KeyBinding keyDecompressAll = new KeyBinding("key.craftingtweaks.decompressAll", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, InputMappings.Type.KEYSYM, InputMappings.field_197958_a.func_197937_c(), "key.categories.craftingtweaks");
    public static final KeyBinding keyRefillLast = new KeyBinding("key.craftingtweaks.refill_last", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, InputMappings.func_197954_a((int)258, (int)0), "key.categories.craftingtweaks");
    public static final KeyBinding keyRefillLastStack = new KeyBinding("key.craftingtweaks.refill_last_stack", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, InputMappings.func_197954_a((int)258, (int)0), "key.categories.craftingtweaks");
    public static KeyBinding keyTransferStack;

    public static void init() {
        ClientRegistry.registerKeyBinding((KeyBinding)keyRotate);
        ClientRegistry.registerKeyBinding((KeyBinding)keyRotateCounterClockwise);
        ClientRegistry.registerKeyBinding((KeyBinding)keyBalance);
        ClientRegistry.registerKeyBinding((KeyBinding)keySpread);
        ClientRegistry.registerKeyBinding((KeyBinding)keyClear);
        ClientRegistry.registerKeyBinding((KeyBinding)keyForceClear);
        ClientRegistry.registerKeyBinding((KeyBinding)keyToggleButtons);
        ClientRegistry.registerKeyBinding((KeyBinding)keyCompressOne);
        ClientRegistry.registerKeyBinding((KeyBinding)keyCompressStack);
        ClientRegistry.registerKeyBinding((KeyBinding)keyCompressAll);
        ClientRegistry.registerKeyBinding((KeyBinding)keyDecompressOne);
        ClientRegistry.registerKeyBinding((KeyBinding)keyDecompressStack);
        ClientRegistry.registerKeyBinding((KeyBinding)keyDecompressAll);
        ClientRegistry.registerKeyBinding((KeyBinding)keyRefillLast);
        ClientRegistry.registerKeyBinding((KeyBinding)keyRefillLastStack);
        keyTransferStack = Minecraft.func_71410_x().field_71474_y.field_74351_w;
    }

    private static boolean isActiveAndMatches(KeyBinding keyBinding, InputMappings.Input input) {
        if (keyBinding.getKeyModifier() == KeyModifier.NONE && (KeyModifier.SHIFT.isActive(keyBinding.getKeyConflictContext()) || KeyModifier.CONTROL.isActive(keyBinding.getKeyConflictContext()) || KeyModifier.ALT.isActive(keyBinding.getKeyConflictContext()))) {
            return false;
        }
        return keyBinding.isActiveAndMatches(input);
    }

    public static boolean isActiveIgnoreContext(KeyBinding keyBinding) {
        return keyBinding.getKey().func_197938_b() == InputMappings.Type.KEYSYM && InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)keyBinding.getKey().func_197937_c());
    }

    @Nullable
    public static CompressType getCompressTypeForKey(InputMappings.Input input) {
        if (KeyBindings.isActiveAndMatches(keyCompressOne, input)) {
            return CompressType.COMPRESS_ONE;
        }
        if (KeyBindings.isActiveAndMatches(keyCompressStack, input)) {
            return CompressType.COMPRESS_STACK;
        }
        if (KeyBindings.isActiveAndMatches(keyCompressAll, input)) {
            return CompressType.COMPRESS_ALL;
        }
        if (KeyBindings.isActiveAndMatches(keyDecompressOne, input)) {
            return CompressType.DECOMPRESS_ONE;
        }
        if (KeyBindings.isActiveAndMatches(keyDecompressStack, input)) {
            return CompressType.DECOMPRESS_STACK;
        }
        if (KeyBindings.isActiveAndMatches(keyDecompressAll, input)) {
            return CompressType.DECOMPRESS_ALL;
        }
        return null;
    }
}

