/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Server {
    public static long ticks;

    @SubscribeEvent
    public static void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++ticks;
        }
    }

    public static void chatToAll(BiConsumer<PlayerEntity, List<ITextComponent>> biConsumer) {
        ArrayList textComponents = new ArrayList();
        Server.get().func_184103_al().func_181057_v().forEach(player -> {
            biConsumer.accept((PlayerEntity)player, textComponents);
            for (ITextComponent textComponent : textComponents) {
                player.func_145747_a(textComponent);
            }
        });
    }

    public static <T extends WorldSavedData> T getData(Supplier<T> supplier) {
        return Server.getData(supplier, 0);
    }

    public static <T extends WorldSavedData> T getData(Supplier<T> supplier, Dimension dim) {
        return Server.getData(supplier, dim.func_186058_p());
    }

    public static <T extends WorldSavedData> T getData(Supplier<T> supplier, DimensionType dim) {
        return Server.getData(supplier, dim.func_186068_a());
    }

    public static <T extends WorldSavedData> T getData(Supplier<T> supplier, int dim) {
        Optional<ServerWorld> world = Server.getWorld(dim);
        WorldSavedData[] data = new WorldSavedData[]{(WorldSavedData)supplier.get()};
        world.ifPresent(serverWorld -> {
            DimensionSavedDataManager dataManager = serverWorld.func_217481_x();
            data[0] = dataManager.func_215753_b(supplier, ((WorldSavedData)supplier.get()).func_195925_e());
            if (data[0] == null) {
                data[0] = (WorldSavedData)supplier.get();
                data[0].func_76185_a();
                dataManager.func_215757_a(data[0]);
            }
        });
        return (T)data[0];
    }

    public static Optional<ServerWorld> getWorld(int dimId) {
        return Server.getWorld(DimensionType.func_186069_a((int)dimId));
    }

    public static Optional<ServerWorld> getWorld(ResourceLocation dimName) {
        return Server.getWorld(DimensionType.func_193417_a((ResourceLocation)dimName));
    }

    public static Optional<ServerWorld> getWorld(@Nullable DimensionType dim) {
        return dim == null ? Optional.empty() : Optional.ofNullable(DimensionManager.getWorld((MinecraftServer)Server.get(), (DimensionType)dim, (boolean)false, (boolean)false));
    }

    public static boolean hasPlayers() {
        return !Server.get().func_184103_al().func_181057_v().isEmpty();
    }

    public static boolean isSinglePlayer() {
        return !Server.isMultiPlayer();
    }

    public static boolean isMultiPlayer() {
        return Server.get().func_71262_S();
    }

    public static MinecraftServer get() {
        return (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
    }
}

