/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.playerprops;

import java.util.HashMap;
import java.util.Map;
import mcjty.rftoolsutility.playerprops.PacketSendBuffsToClient;
import mcjty.rftoolsutility.playerprops.PlayerBuff;
import mcjty.rftoolsutility.playerprops.PlayerExtendedProperties;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fml.network.NetworkDirection;

public class BuffProperties {
    public static final int BUFF_MAXTICKS = 180;
    private int buffTimeout = 0;
    private final Map<PlayerBuff, Integer> buffs = new HashMap<PlayerBuff, Integer>();
    private boolean oldAllowFlying = false;
    private boolean allowFlying = false;
    private boolean globalSyncNeeded = true;
    private boolean onElevator = false;

    private void syncBuffs(ServerPlayerEntity player) {
        RFToolsUtilityMessages.INSTANCE.sendTo((Object)new PacketSendBuffsToClient(this.buffs), player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void tickBuffs(ServerPlayerEntity player) {
        --this.buffTimeout;
        if (this.buffTimeout <= 0) {
            this.buffTimeout = 180;
            HashMap<PlayerBuff, Integer> copyBuffs = new HashMap<PlayerBuff, Integer>(this.buffs);
            this.buffs.clear();
            boolean syncNeeded = false;
            for (Map.Entry entry : copyBuffs.entrySet()) {
                int timeout = (Integer)entry.getValue();
                if ((timeout -= 180) > 0) {
                    this.buffs.put((PlayerBuff)((Object)entry.getKey()), timeout);
                    continue;
                }
                syncNeeded = true;
            }
            if (syncNeeded) {
                this.syncBuffs(player);
                this.performBuffs(player);
                this.globalSyncNeeded = false;
            }
        }
        if (this.globalSyncNeeded) {
            this.globalSyncNeeded = false;
            this.syncBuffs(player);
            this.performBuffs(player);
        }
    }

    private void performBuffs(ServerPlayerEntity player) {
        boolean enableFlight = false;
        if (this.onElevator) {
            enableFlight = true;
            player.field_71075_bZ.field_75100_b = true;
        } else {
            for (PlayerBuff buff : this.buffs.keySet()) {
                if (buff != PlayerBuff.BUFF_FLIGHT) continue;
                enableFlight = true;
                break;
            }
        }
        boolean oldAllow = player.field_71075_bZ.field_75101_c;
        if (enableFlight) {
            if (!this.allowFlying) {
                this.oldAllowFlying = player.field_71075_bZ.field_75101_c;
                this.allowFlying = true;
            }
            player.field_71075_bZ.field_75101_c = true;
        } else if (this.allowFlying) {
            player.field_71075_bZ.field_75101_c = this.oldAllowFlying;
            if (player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75101_c = true;
            }
            this.allowFlying = false;
        }
        if (player.field_71075_bZ.field_75101_c != oldAllow && !player.field_71075_bZ.field_75101_c) {
            player.field_71075_bZ.field_75100_b = false;
        }
        player.func_71016_p();
    }

    public static void enableElevatorMode(PlayerEntity player) {
        PlayerExtendedProperties.getBuffProperties(player).ifPresent(h -> {
            h.onElevator = true;
            h.performBuffs((ServerPlayerEntity)player);
        });
    }

    public static void disableElevatorMode(PlayerEntity player) {
        PlayerExtendedProperties.getBuffProperties(player).ifPresent(h -> {
            h.onElevator = false;
            player.field_71075_bZ.field_75100_b = false;
            h.performBuffs((ServerPlayerEntity)player);
        });
    }

    public static void addBuffToPlayer(PlayerEntity player, PlayerBuff buff, int ticks) {
        PlayerExtendedProperties.getBuffProperties(player).ifPresent(h -> h.addBuff((ServerPlayerEntity)player, buff, ticks));
    }

    public void addBuff(ServerPlayerEntity player, PlayerBuff buff, int ticks) {
        this.buffs.put(buff, ticks + 5);
        this.syncBuffs(player);
        this.performBuffs(player);
    }

    public Map<PlayerBuff, Integer> getBuffs() {
        return this.buffs;
    }

    public boolean hasBuff(PlayerBuff buff) {
        return this.buffs.containsKey((Object)buff);
    }

    public void saveNBTData(CompoundNBT compound) {
        compound.func_74757_a("onElevator", this.onElevator);
        compound.func_74768_a("buffTicks", this.buffTimeout);
        compound.func_74757_a("allowFlying", this.allowFlying);
        compound.func_74757_a("oldAllowFlying", this.oldAllowFlying);
        int[] buffArray = new int[this.buffs.size()];
        int[] timeoutArray = new int[this.buffs.size()];
        int idx = 0;
        for (Map.Entry<PlayerBuff, Integer> entry : this.buffs.entrySet()) {
            PlayerBuff buff = entry.getKey();
            buffArray[idx] = buff.ordinal();
            timeoutArray[idx] = entry.getValue();
            ++idx;
        }
        compound.func_74783_a("buffs", buffArray);
        compound.func_74783_a("buffTimeouts", timeoutArray);
    }

    public void loadNBTData(CompoundNBT compound) {
        this.onElevator = compound.func_74767_n("onElevator");
        this.buffTimeout = compound.func_74762_e("buffTicks");
        int[] buffArray = compound.func_74759_k("buffs");
        int[] timeoutArray = compound.func_74759_k("buffTimeouts");
        this.buffs.clear();
        for (int i = 0; i < buffArray.length; ++i) {
            int buffIdx = buffArray[i];
            this.buffs.put(PlayerBuff.values()[buffIdx], timeoutArray[i]);
        }
        this.allowFlying = compound.func_74767_n("allowFlying");
        this.oldAllowFlying = compound.func_74767_n("oldAllowFlying");
        this.globalSyncNeeded = true;
    }
}

