/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.config.machine.resourceproduction.WaterCondensatorConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.energy.NBTEnergyHandler;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.DyeColor;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class WaterCondensatorTile
extends IndustrialWorkingTile<WaterCondensatorTile> {
    private int getMaxProgress;
    private int getPowerPerOperation;
    @Save
    private SidedFluidTankComponent<WaterCondensatorTile> water = (SidedFluidTankComponent)new SidedFluidTankComponent("water", WaterCondensatorConfig.maxWaterTankSize, 43, 20, 0).setColor(DyeColor.BLUE).setComponentHarness((IComponentHarness)this).setTankAction(FluidTankComponent.Action.DRAIN).setValidator(fluidStack -> fluidStack.getFluid().func_207187_a((Fluid)Fluids.field_204546_a));

    public WaterCondensatorTile() {
        super(ModuleResourceProduction.WATER_CONDENSATOR);
        this.addTank((FluidTankComponent)this.water);
        this.getMaxProgress = WaterCondensatorConfig.maxProgress;
        this.getPowerPerOperation = WaterCondensatorConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        int water = this.getWaterSources();
        if (water >= 2) {
            if (this.hasEnergy(this.getPowerPerOperation)) {
                this.water.fillForced(new FluidStack((Fluid)Fluids.field_204546_a, water * 10), IFluidHandler.FluidAction.EXECUTE);
                return new IndustrialWorkingTile.WorkAction(0.1f, this.getPowerPerOperation);
            }
            this.water.fillForced(new FluidStack((Fluid)Fluids.field_204546_a, water * 5), IFluidHandler.FluidAction.EXECUTE);
            return new IndustrialWorkingTile.WorkAction(0.5f, 0);
        }
        return new IndustrialWorkingTile.WorkAction(1.0f, 0);
    }

    protected IFactory<NBTEnergyHandler> getEnergyHandlerFactory() {
        return () -> new NBTEnergyHandler((BasicTile)this, WaterCondensatorConfig.maxStoredPower);
    }

    @Override
    public int getMaxProgress() {
        return this.getMaxProgress;
    }

    private int getWaterSources() {
        int amount = 0;
        for (Direction value : Direction.values()) {
            IFluidState fluidState;
            if (!this.field_145850_b.func_175707_a(this.field_174879_c.func_177972_a(value), this.field_174879_c.func_177972_a(value)) || !(fluidState = this.field_145850_b.func_204610_c(this.field_174879_c.func_177972_a(value))).func_206886_c().equals(Fluids.field_204546_a) || !fluidState.func_206889_d()) continue;
            ++amount;
        }
        return amount;
    }

    @Nonnull
    public WaterCondensatorTile getSelf() {
        return this;
    }
}

