/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import journeymap.common.network.impl.CompressedPacket;
import journeymap.common.network.impl.Response;
import journeymap.common.util.PlayerConfigController;
import journeymap.server.nbt.WorldNbtIDSaveHandler;
import journeymap.server.properties.DefaultDimensionProperties;
import journeymap.server.properties.DimensionProperties;
import journeymap.server.properties.GlobalProperties;
import journeymap.server.properties.PermissionProperties;
import journeymap.server.properties.PropertiesManager;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.loading.FMLLoader;

public class GetAllConfigs
extends CompressedPacket {
    @Override
    protected JsonObject onServer(Response response) {
        ServerPlayerEntity player = response.getContext().getSender();
        if (PlayerConfigController.getInstance().canServerAdmin(player) || FMLLoader.getDist().isClient()) {
            return this.collectServerSettings();
        }
        player.func_145747_a((ITextComponent)new StringTextComponent("You do not have permission to modify Journeymap's server options!"));
        return null;
    }

    private JsonObject collectServerSettings() {
        JsonObject serverConfigs = new JsonObject();
        JsonArray dimensionConfigs = new JsonArray();
        JsonObject globalConfig = new JsonObject();
        JsonObject defaultDimConfig = new JsonObject();
        GlobalProperties globalProperties = PropertiesManager.getInstance().getGlobalProperties();
        DefaultDimensionProperties defaultDimensionProperties = PropertiesManager.getInstance().getDefaultDimensionProperties();
        if (FMLLoader.getDist().isDedicatedServer()) {
            globalConfig.addProperty("useWorldId", globalProperties.useWorldId.get());
            globalConfig.addProperty("world_id", new WorldNbtIDSaveHandler().getWorldID());
        } else {
            globalConfig.addProperty("dimName", "global");
        }
        globalConfig.addProperty("op_can_track", globalProperties.opPlayerTrackingEnabled.get());
        globalConfig.addProperty("can_track", globalProperties.playerTrackingEnabled.get());
        globalConfig.addProperty("tracking_time", (Number)globalProperties.playerTrackingUpdateTime.get());
        this.getCommonProperties(globalProperties, globalConfig);
        defaultDimConfig.addProperty("enabled", defaultDimensionProperties.enabled.get());
        defaultDimConfig.addProperty("dimName", "default");
        this.getCommonProperties(defaultDimensionProperties, defaultDimConfig);
        for (DimensionType d : DimensionType.func_212681_b()) {
            JsonObject dim = new JsonObject();
            DimensionProperties dimensionProperties = PropertiesManager.getInstance().getDimProperties(d.func_186068_a());
            dim.addProperty("enabled", dimensionProperties.enabled.get());
            dim.addProperty("dimId", (Number)d.func_186068_a());
            dim.addProperty("dimName", String.valueOf(DimensionType.func_212678_a((DimensionType)d)));
            this.getCommonProperties(dimensionProperties, dim);
            dimensionConfigs.add((JsonElement)dim);
        }
        serverConfigs.add("global", (JsonElement)globalConfig);
        serverConfigs.add("default_dimension", (JsonElement)defaultDimConfig);
        serverConfigs.add("dimensions", (JsonElement)dimensionConfigs);
        return serverConfigs;
    }

    private void getCommonProperties(PermissionProperties from, JsonObject to) {
        to.addProperty("can_teleport", from.teleportEnabled.get());
        to.addProperty("op_surface", from.opSurfaceMappingEnabled.get());
        to.addProperty("surface", from.surfaceMappingEnabled.get());
        to.addProperty("op_topo", from.opTopoMappingEnabled.get());
        to.addProperty("topo", from.topoMappingEnabled.get());
        to.addProperty("op_cave", from.opCaveMappingEnabled.get());
        to.addProperty("cave", from.caveMappingEnabled.get());
        to.addProperty("op_radar", from.opRadarEnabled.get());
        to.addProperty("radar", from.radarEnabled.get());
        to.addProperty("playerRadar", from.playerRadarEnabled.get());
        to.addProperty("villagerRadar", from.villagerRadarEnabled.get());
        to.addProperty("animalRadar", from.animalRadarEnabled.get());
        to.addProperty("mobRadar", from.mobRadarEnabled.get());
    }

    @Override
    protected JsonObject onClient(Response response) {
        return null;
    }
}

