/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world.gen;

import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.world.gen.RatStructure;
import com.github.alexthe666.rats.server.world.structure.RatlantisStructureRegistry;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class RatsStructureProcessor
extends StructureProcessor {
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private final float integrity;

    public RatsStructureProcessor(float integrity) {
        this.integrity = integrity;
    }

    public RatsStructureProcessor(Dynamic<?> p_i51333_1_) {
        this(p_i51333_1_.get("integrity").asFloat(1.0f));
    }

    public Template.BlockInfo func_215194_a(IWorldReader worldReader, BlockPos pos, Template.BlockInfo infoIn1, Template.BlockInfo infoIn2, PlacementSettings settings) {
        Random random = settings.func_189947_a(infoIn2.field_186242_a);
        if (random.nextFloat() <= this.integrity && infoIn2.field_186243_b.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_BRICK) {
            return new Template.BlockInfo(infoIn2.field_186242_a, RatStructure.getRandomCrackedBlock(infoIn2.field_186243_b, random), null);
        }
        return infoIn2;
    }

    protected IStructureProcessorType func_215192_a() {
        return RatlantisStructureRegistry.RAT_RUINS_PROCESSOR;
    }

    protected <T> Dynamic<T> func_215193_a(DynamicOps<T> ops) {
        return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("integrity"), (Object)ops.createFloat(this.integrity))));
    }
}

