/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.tile;

import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.tile.RatsTileEntityRegistry;
import com.github.alexthe666.rats.server.entity.tile.TrashCanInventoryWrapperBottom;
import com.github.alexthe666.rats.server.entity.tile.TrashCanInventoryWrapperTop;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityTrashCan
extends TileEntity
implements ITickableTileEntity {
    public boolean opened = false;
    public float lidProgress;
    public float prevLidProgress;
    public int trashStored;
    int ticksExisted;
    LazyOptional<? extends IItemHandler> upHandler = TrashCanInventoryWrapperTop.create(this, Direction.UP);
    LazyOptional<? extends IItemHandler> downHandler = TrashCanInventoryWrapperBottom.create(this, Direction.DOWN);
    private int timeOpen = 0;

    public TileEntityTrashCan() {
        super(RatsTileEntityRegistry.TRASH_CAN);
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        this.prevLidProgress = this.lidProgress;
        float lidInc = 2.0f;
        if (this.opened && this.lidProgress < 20.0f) {
            this.lidProgress += lidInc;
        } else if (!this.opened && this.lidProgress > 0.0f) {
            this.lidProgress -= lidInc;
        }
        if (this.opened) {
            ++this.timeOpen;
            if (this.timeOpen > 30) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, RatsSoundRegistry.TRASH_CAN, SoundCategory.BLOCKS, 0.7f, 0.75f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f);
                this.opened = false;
                this.timeOpen = 0;
            }
        }
        if (this.trashStored >= 7) {
            BlockPos down = this.func_174877_v().func_177977_b();
            TileEntity tileEntity = this.field_145850_b.func_175625_s(down);
            boolean flag = false;
            if (tileEntity != null && tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).isPresent()) {
                flag = true;
            }
            if (!flag) {
                this.trashStored = 0;
                this.depositGarbage();
                BlockState blockstate = this.field_145850_b.func_180495_p(this.func_174877_v());
                this.field_145850_b.func_184138_a(this.func_174877_v(), blockstate, blockstate, 3);
            }
        }
    }

    public void depositGarbage() {
        ItemEntity itemEntity = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, new ItemStack((IItemProvider)RatsBlockRegistry.GARBAGE_PILE));
        this.field_145850_b.func_217376_c((Entity)itemEntity);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tag = new CompoundNBT();
        this.func_189515_b(tag);
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("TrashStored", this.trashStored);
        compound.func_74768_a("TicksExisted", this.ticksExisted);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(CompoundNBT compound) {
        this.ticksExisted = compound.func_74762_e("TicksExisted");
        this.trashStored = compound.func_74762_e("TrashStored");
        super.func_145839_a(compound);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.downHandler.cast();
            }
            return this.upHandler.cast();
        }
        return super.getCapability(capability, facing);
    }
}

