/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.tile;

import com.github.alexthe666.rats.server.blocks.BlockRatTube;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.tile.RatsTileEntityRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class TileEntityRatTube
extends TileEntity
implements ITickableTileEntity {
    private static BooleanProperty[] allOpenVars = new BooleanProperty[]{BlockRatTube.OPEN_DOWN, BlockRatTube.OPEN_EAST, BlockRatTube.OPEN_NORTH, BlockRatTube.OPEN_SOUTH, BlockRatTube.OPEN_UP, BlockRatTube.OPEN_WEST};
    public Direction opening = null;
    public boolean isNode = false;
    private int color;

    public TileEntityRatTube() {
        super(RatsTileEntityRegistry.RAT_TUBE);
    }

    public void func_73660_a() {
        if (this.isOpen()) {
            float i = (float)this.func_174877_v().func_177958_n() + 0.5f;
            float j = (float)this.func_174877_v().func_177956_o() + 0.2f;
            float k = (float)this.func_174877_v().func_177952_p() + 0.5f;
            float d0 = 0.4f;
            for (EntityRat rat : this.field_145850_b.func_217357_a(EntityRat.class, new AxisAlignedBB((double)i - (double)d0, (double)j - (double)d0, (double)k - (double)d0, (double)i + (double)d0, (double)j + (double)d0, (double)k + (double)d0))) {
                rat.func_213295_a(this.func_195044_w(), new Vec3d(1.75, 1.0, 1.75));
                this.updateRat(rat);
            }
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    private void updateRat(EntityRat rat) {
    }

    private boolean isOpen() {
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockRatTube) {
            for (BooleanProperty opened : allOpenVars) {
                if (!((Boolean)state.func_177229_b((IProperty)opened)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74757_a("Node", this.isNode);
        compound.func_74768_a("OpenSide", this.opening == null ? -1 : this.opening.ordinal());
        compound.func_74768_a("TubeColor", this.color);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(CompoundNBT compound) {
        this.isNode = compound.func_74767_n("Node");
        int i = compound.func_74762_e("OpenSide");
        this.opening = i == -1 ? null : Direction.values()[MathHelper.func_76125_a((int)i, (int)0, (int)(Direction.values().length - 1))];
        this.color = compound.func_74762_e("TubeColor");
        super.func_145839_a(compound);
    }

    public void setEntranceData(Direction side, boolean open) {
        if (open) {
            this.opening = side;
            this.isNode = true;
        } else {
            this.opening = null;
            this.isNode = false;
        }
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int colorIn) {
        this.color = colorIn;
    }
}

