/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.IShearable;

public class RatAIHarvestShears
extends Goal {
    private static final int RADIUS = 16;
    private static final ItemStack SHEAR_STACK = new ItemStack((IItemProvider)Items.field_151097_aZ);
    private final EntityRat entity;
    private Entity targetSheep = null;
    private boolean reachedSheep = false;
    private int fishingCooldown = 1000;
    private int throwCooldown = 0;
    private Random rand = new Random();
    private Predicate<LivingEntity> SHEAR_PREDICATE = new com.google.common.base.Predicate<LivingEntity>(){

        public boolean apply(@Nullable LivingEntity entity) {
            return entity != null && entity instanceof IShearable && ((IShearable)entity).isShearable(SHEAR_STACK, (IWorldReader)entity.field_70170_p, entity.func_180425_c());
        }
    };

    public RatAIHarvestShears(EntityRat entity) {
        this.entity = entity;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!this.entity.canMove() || !this.entity.func_70909_n() || this.entity.getCommand() != RatCommand.HARVEST || this.entity.isInCage() || !this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_SHEARS)) {
            return false;
        }
        if (!this.entity.func_184614_ca().func_190926_b()) {
            return false;
        }
        this.resetTarget();
        return this.targetSheep != null;
    }

    public boolean func_75253_b() {
        return this.targetSheep != null && this.entity.func_184614_ca().func_190926_b();
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public void func_75246_d() {
        if (this.targetSheep != null && this.targetSheep.func_70089_S() && this.entity.func_184614_ca().func_190926_b()) {
            this.entity.func_70661_as().func_75497_a(this.targetSheep, 1.25);
            if ((double)this.entity.func_70032_d(this.targetSheep) < 1.5 * this.entity.getRatDistanceModifier()) {
                if (this.targetSheep instanceof IShearable) {
                    List drops = ((IShearable)this.targetSheep).onSheared(new ItemStack((IItemProvider)Items.field_151097_aZ), (IWorld)this.entity.field_70170_p, this.targetSheep.func_180425_c(), 0);
                    for (ItemStack stack : drops) {
                        this.targetSheep.func_70099_a(stack, 0.0f);
                    }
                }
                this.targetSheep = null;
                this.func_75251_c();
            }
        } else {
            this.func_75251_c();
        }
    }

    private void resetTarget() {
        int radius = this.entity.getSearchRadius();
        AxisAlignedBB bb = new AxisAlignedBB((double)(-radius), (double)(-radius), (double)(-radius), (double)radius, (double)radius, (double)radius).func_186670_a(this.entity.getSearchCenter());
        List list = this.entity.field_70170_p.func_175647_a(LivingEntity.class, bb, (Predicate)((com.google.common.base.Predicate)this.SHEAR_PREDICATE));
        LivingEntity closestSheep = null;
        for (LivingEntity base : list) {
            if (closestSheep != null && !(base.func_70068_e((Entity)this.entity) < closestSheep.func_70068_e((Entity)this.entity))) continue;
            closestSheep = base;
        }
        if (closestSheep != null) {
            this.targetSheep = closestSheep;
        }
    }
}

