/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RatAIFollowOwner
extends Goal {
    private final EntityRat rat;
    private final double followSpeed;
    World world;
    float maxDist;
    float minDist;
    private LivingEntity owner;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public RatAIFollowOwner(EntityRat tameableIn, double followSpeedIn, float minDistIn, float maxDistIn) {
        this.rat = tameableIn;
        this.world = tameableIn.field_70170_p;
        this.followSpeed = followSpeedIn;
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if ((this.rat.func_70909_n() || this.rat.wasTamedByMonster()) && this.rat.isFollowing()) {
            LivingEntity LivingEntity2 = this.rat.func_70902_q();
            if (LivingEntity2 == null) {
                LivingEntity2 = this.rat.getMonsterOwner();
            }
            if (LivingEntity2 == null) {
                return false;
            }
            if (LivingEntity2 instanceof PlayerEntity && ((PlayerEntity)LivingEntity2).func_175149_v()) {
                return false;
            }
            if (this.rat.func_70906_o()) {
                return false;
            }
            if (this.rat.func_70068_e((Entity)LivingEntity2) < (double)(this.minDist * this.minDist)) {
                return false;
            }
            this.owner = LivingEntity2;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.rat.func_70661_as().func_75500_f() && this.rat.isFollowing() && this.rat.func_70068_e((Entity)this.owner) > (double)(this.maxDist * this.maxDist);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.rat.func_184643_a(PathNodeType.WATER);
        this.rat.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.rat.func_70661_as().func_75499_g();
        this.rat.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.rat.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.rat.func_70646_bf());
        if (this.rat.isFollowing() && --this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            boolean teleport = false;
            if (!this.rat.func_110167_bD() && !this.rat.func_184218_aH() && this.owner instanceof PlayerEntity && this.rat.func_70068_e((Entity)this.owner) >= 144.0) {
                teleport = true;
                int i = MathHelper.func_76128_c((double)this.owner.func_226277_ct_()) - 2;
                int j = MathHelper.func_76128_c((double)this.owner.func_226281_cx_()) - 2;
                int k = MathHelper.func_76128_c((double)this.owner.func_174813_aQ().field_72338_b);
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.canTeleportToBlock(new BlockPos(i + l, k - 1, j + i1))) continue;
                        this.rat.func_70012_b((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.rat.field_70177_z, this.rat.field_70125_A);
                        this.rat.func_70661_as().func_75499_g();
                        return;
                    }
                }
            }
            if (!teleport) {
                this.rat.func_70661_as().func_75497_a((Entity)this.owner, this.followSpeed);
            }
        }
    }

    protected boolean canTeleportToBlock(BlockPos pos) {
        BlockState blockstate = this.world.func_180495_p(pos);
        return blockstate.func_215688_a((IBlockReader)this.world, pos, this.rat.func_200600_R()) && this.world.func_175623_d(pos.func_177984_a()) && this.world.func_175623_d(pos.func_177981_b(2));
    }
}

