/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.server.entity.EntityPiratBoat;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.IPirat;
import com.github.alexthe666.rats.server.entity.IRatlantean;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import com.github.alexthe666.rats.server.entity.ai.PiratAIStrife;
import com.github.alexthe666.rats.server.entity.ai.PiratAIWander;
import com.github.alexthe666.rats.server.entity.ai.PiratPathNavigate;
import com.github.alexthe666.rats.server.entity.ai.RatAIEnterTrap;
import com.github.alexthe666.rats.server.entity.ai.RatAIFleeSun;
import com.github.alexthe666.rats.server.entity.ai.RatAIHurtByTarget;
import com.github.alexthe666.rats.server.entity.ai.RatAISit;
import com.github.alexthe666.rats.server.entity.ai.RatAIWander;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.Arrays;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class EntityPirat
extends EntityRat
implements IRangedAttackMob,
IRatlantean,
IMob,
IPirat {
    private PiratAIStrife aiArrowAttack;
    private MeleeAttackGoal aiAttackOnCollide;
    private int attackCooldown = 70;

    public EntityPirat(EntityType type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.waterBased = true;
        Arrays.fill(this.field_184655_bs, 0.2f);
        Arrays.fill(this.field_82174_bp, 0.2f);
        this.field_70765_h = new PiratMoveController((MobEntity)this);
        this.field_70699_by = new PiratPathNavigate((MobEntity)this, this.field_70170_p);
    }

    public boolean func_70090_H() {
        return super.func_70090_H() && !this.func_184218_aH();
    }

    @Override
    protected void switchNavigator(int type) {
    }

    public static boolean canSpawn(EntityType<EntityPirat> p_223332_0_, IWorld p_223332_1_, SpawnReason p_223332_2_, BlockPos p_223332_3_, Random p_223332_4_) {
        Biome biome = p_223332_1_.func_226691_t_(p_223332_3_);
        boolean flag = p_223332_1_.func_175659_aa() != Difficulty.PEACEFUL && EntityPirat.func_223323_a(p_223332_1_, p_223332_3_, p_223332_4_) && (p_223332_2_ == SpawnReason.SPAWNER || p_223332_1_.func_204610_c(p_223332_3_).func_206884_a(FluidTags.field_206959_a));
        return p_223332_4_.nextInt(150) == 0 && flag;
    }

    public static boolean func_223323_a(IWorld p_223323_0_, BlockPos p_223323_1_, Random p_223323_2_) {
        return p_223323_0_.func_226658_a_(LightType.SKY, p_223323_1_) > 10;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.aiArrowAttack = new PiratAIStrife(this, 1.0, 20, 30.0f);
        this.field_70714_bg.func_75776_a(1, (Goal)this.aiArrowAttack);
        this.aiAttackOnCollide = new MeleeAttackGoal((CreatureEntity)this, 1.45, false);
        this.field_70714_bg.func_75776_a(1, (Goal)this.aiAttackOnCollide);
        this.field_70714_bg.func_75776_a(2, (Goal)new PiratAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new RatAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new RatAIFleeSun(this, 1.66));
        this.field_70911_d = new RatAISit(this);
        this.field_70714_bg.func_75776_a(3, (Goal)this.field_70911_d);
        this.field_70714_bg.func_75776_a(5, (Goal)new RatAIEnterTrap(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 5, true, false, (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity entity) {
                return !(entity instanceof IRatlantean) && entity instanceof LivingEntity && !entity.func_184191_r((Entity)EntityPirat.this) && (!(entity instanceof PlayerEntity) || !((PlayerEntity)entity).func_184812_l_());
            }
        }));
        this.field_70715_bh.func_75776_a(2, (Goal)new RatAIHurtByTarget(this, new Class[0]));
        this.field_70714_bg.func_85156_a((Goal)this.aiAttackOnCollide);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    public void func_70624_b(@Nullable LivingEntity LivingEntityIn) {
        super.func_70624_b(LivingEntityIn);
        this.setCombatTask();
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((Goal)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a((Goal)this.aiArrowAttack);
            if (this.func_184218_aH()) {
                int i = 20;
                if (this.field_70170_p.func_175659_aa() != Difficulty.HARD) {
                    i = 40;
                }
                this.aiArrowAttack.setAttackCooldown(i);
                this.field_70714_bg.func_75776_a(1, (Goal)this.aiArrowAttack);
            } else {
                this.field_70714_bg.func_75776_a(1, (Goal)this.aiAttackOnCollide);
            }
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.holdInMouth = false;
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setCombatTask();
    }

    public double func_70033_W() {
        return 0.45;
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setMale(this.func_70681_au().nextBoolean());
        this.setPlague(false);
        this.setToga(false);
        this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)RatsItemRegistry.PIRAT_CUTLASS));
        this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)RatsItemRegistry.PIRAT_HAT));
        if (!this.func_184218_aH()) {
            EntityPiratBoat boat = new EntityPiratBoat(RatsEntityRegistry.PIRAT_BOAT, this.field_70170_p);
            boat.func_82149_j((Entity)this);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217376_c((Entity)boat);
            }
            this.func_184205_a((Entity)boat, true);
        }
        this.setCombatTask();
        return spawnDataIn;
    }

    @Override
    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        BlockPos pos = new BlockPos((Entity)this);
        BlockState BlockState2 = this.field_70170_p.func_180495_p(pos.func_177977_b());
        return this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL && this.isValidLightLevel() && BlockState2.func_185904_a() == Material.field_151586_h && this.field_70146_Z.nextFloat() < 0.1f;
    }

    @Override
    public boolean canBeTamed() {
        return false;
    }

    public boolean func_70909_n() {
        return false;
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        boolean flag = super.func_184205_a(entityIn, force);
        this.setCombatTask();
        return flag;
    }

    public void func_184210_p() {
        super.func_184210_p();
        this.setCombatTask();
    }

    public boolean func_70072_I() {
        if (this.func_184187_bx() instanceof EntityPiratBoat) {
            this.field_70171_ac = false;
        } else if (this.func_210500_b(FluidTags.field_206959_a)) {
            if (!this.field_70171_ac && !this.field_70148_d) {
                this.func_71061_d_();
            }
            this.field_70143_R = 0.0f;
            this.field_70171_ac = true;
            this.func_70066_B();
        } else {
            this.field_70171_ac = false;
        }
        return this.field_70171_ac;
    }

    @Override
    public void updateRiding(Entity riding) {
        super.updateRiding(riding);
        this.func_70107_b(riding.func_226277_ct_(), riding.func_226278_cu_() + 0.5, riding.func_226281_cx_());
    }

    @Override
    public void func_70098_U() {
        super.func_70098_U();
        Entity entity = this.func_184187_bx();
        if (this.func_184218_aH() && !entity.func_70089_S()) {
            this.func_184210_p();
        } else {
            this.func_213293_j(0.0, 0.0, 0.0);
            if (!this.field_70148_d) {
                this.func_70071_h_();
            }
            if (this.func_184218_aH()) {
                entity.func_184232_k((Entity)this);
            }
        }
        this.field_70768_au = this.field_110154_aX;
        this.field_110154_aX = 0.0f;
        this.field_70143_R = 0.0f;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (this.attackCooldown == 0) {
            this.func_70625_a((Entity)target, 180.0f, 180.0f);
            double d0 = target.func_226277_ct_() - this.func_226277_ct_();
            double d2 = target.func_226281_cx_() - this.func_226281_cx_();
            float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            this.field_70761_aq = this.field_70177_z = f % 360.0f;
            if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityPiratBoat) {
                ((EntityPiratBoat)this.func_184187_bx()).shoot(this);
            }
            this.attackCooldown = 70;
        }
    }

    @Override
    public boolean shouldHuntAnimal() {
        return true;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public class PiratMoveController
    extends MovementController {
        public PiratMoveController(MobEntity LivingEntityIn) {
            super(LivingEntityIn);
        }

        public void func_75641_c() {
            super.func_75641_c();
        }
    }
}

