/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityLaserBeam
extends AbstractArrowEntity {
    private static final DataParameter<Float> R = EntityDataManager.func_187226_a(EntityLaserBeam.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> G = EntityDataManager.func_187226_a(EntityLaserBeam.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> B = EntityDataManager.func_187226_a(EntityLaserBeam.class, (IDataSerializer)DataSerializers.field_187193_c);

    public EntityLaserBeam(EntityType type, World worldIn) {
        super(type, worldIn);
        this.func_70239_b(6.0);
    }

    public EntityLaserBeam(EntityType type, World worldIn, double x, double y, double z, float r, float g, float b) {
        this(type, worldIn);
        this.func_70107_b(x, y, z);
        this.func_70239_b(6.0);
    }

    public EntityLaserBeam(EntityType type, World worldIn, LivingEntity shooter) {
        super(type, shooter, worldIn);
        this.func_70239_b(RatConfig.neoRatlanteanAttack);
    }

    public EntityLaserBeam(FMLPlayMessages.SpawnEntity spawnEntity, World worldIn) {
        this(RatsEntityRegistry.LASER_BEAM, worldIn);
    }

    public boolean func_70090_H() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(R, (Object)Float.valueOf(0.66f));
        this.field_70180_af.func_187214_a(G, (Object)Float.valueOf(0.97f));
        this.field_70180_af.func_187214_a(B, (Object)Float.valueOf(0.97f));
    }

    public float[] getRGB() {
        return new float[]{((Float)this.field_70180_af.func_187225_a(R)).floatValue(), ((Float)this.field_70180_af.func_187225_a(G)).floatValue(), ((Float)this.field_70180_af.func_187225_a(B)).floatValue()};
    }

    public void setRGB(float newR, float newG, float newB) {
        this.field_70180_af.func_187227_b(R, (Object)Float.valueOf(newR));
        this.field_70180_af.func_187227_b(G, (Object)Float.valueOf(newG));
        this.field_70180_af.func_187227_b(B, (Object)Float.valueOf(newB));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("ColorR", this.getRGB()[0]);
        compound.func_74776_a("ColorG", this.getRGB()[1]);
        compound.func_74776_a("ColorB", this.getRGB()[2]);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setRGB(compound.func_74760_g("ColorR"), compound.func_74760_g("ColorG"), compound.func_74760_g("ColorB"));
    }

    public void func_70071_h_() {
        float sqrt = (float)this.func_213322_ci().func_72433_c();
        if (sqrt < 0.3f || this.field_70254_i || this.field_70123_F) {
            this.func_70106_y();
            Explosion.Mode mode = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) ? Explosion.Mode.NONE : Explosion.Mode.DESTROY;
            Explosion explosion = this.field_70170_p.func_217385_a(this.func_212360_k(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, mode);
            explosion.func_77278_a();
            explosion.func_77279_a(true);
        }
        super.func_70071_h_();
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        if (!this.func_174814_R() && soundIn != SoundEvents.field_187731_t && soundIn != SoundEvents.field_187734_u) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), soundIn, this.func_184176_by(), volume, pitch);
        }
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        if (raytraceResultIn instanceof EntityRayTraceResult && this.func_212360_k() != null && this.func_212360_k().func_184191_r(((EntityRayTraceResult)raytraceResultIn).func_216348_a())) {
            return;
        }
        if (raytraceResultIn instanceof EntityRayTraceResult && ((EntityRayTraceResult)raytraceResultIn).func_216348_a() instanceof PlayerEntity) {
            this.damageShield((PlayerEntity)((EntityRayTraceResult)raytraceResultIn).func_216348_a(), (float)this.func_70242_d());
        }
        super.func_184549_a(raytraceResultIn);
    }

    protected void damageShield(PlayerEntity player, float damage) {
        if (damage >= 3.0f && player.func_184607_cu().func_77973_b().isShield(player.func_184607_cu(), (LivingEntity)player)) {
            ItemStack copyBeforeUse = player.func_184607_cu().func_77946_l();
            int i = 1 + MathHelper.func_76141_d((float)damage);
            player.func_184607_cu().func_222118_a(i, (LivingEntity)player, p_220048_0_ -> p_220048_0_.func_213361_c(EquipmentSlotType.MAINHAND));
            if (player.func_184607_cu().func_190926_b()) {
                Hand Hand2 = player.func_184600_cs();
                ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)copyBeforeUse, (Hand)Hand2);
                if (Hand2 == Hand.MAIN_HAND) {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                } else {
                    this.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
                }
                player.func_184602_cy();
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBrightnessForRender() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public boolean func_189652_ae() {
        return true;
    }

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

