/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transmitters.grid;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.math.MathUtils;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.distribution.target.FluidHandlerTarget;
import mekanism.common.distribution.target.FluidTransmitterSaveTarget;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidNetwork
extends DynamicNetwork<IFluidHandler, FluidNetwork, FluidStack>
implements IMekanismFluidHandler {
    private final List<IExtendedFluidTank> fluidTanks;
    public final VariableCapacityFluidTank fluidTank;
    @Nonnull
    public FluidStack lastFluid = FluidStack.EMPTY;
    public float fluidScale;
    private int prevTransferAmount;
    private int intCapacity;

    public FluidNetwork() {
        this.fluidTank = VariableCapacityFluidTank.create(this::getCapacityAsInt, BasicFluidTank.alwaysTrueBi, BasicFluidTank.alwaysTrueBi, BasicFluidTank.alwaysTrue, (IMekanismFluidHandler)this);
        this.fluidTanks = Collections.singletonList(this.fluidTank);
    }

    public FluidNetwork(UUID networkID) {
        super(networkID);
        this.fluidTank = VariableCapacityFluidTank.create(this::getCapacityAsInt, BasicFluidTank.alwaysTrueBi, BasicFluidTank.alwaysTrueBi, BasicFluidTank.alwaysTrue, (IMekanismFluidHandler)this);
        this.fluidTanks = Collections.singletonList(this.fluidTank);
    }

    public FluidNetwork(Collection<FluidNetwork> networks) {
        this();
        for (FluidNetwork net : networks) {
            if (net == null) continue;
            this.adoptTransmittersAndAcceptorsFrom(net);
            net.deregister();
        }
        this.register();
    }

    @Override
    protected void forceScaleUpdate() {
        this.fluidScale = !this.fluidTank.isEmpty() && this.fluidTank.getCapacity() > 0 ? Math.min(1.0f, (float)this.fluidTank.getFluidAmount() / (float)this.fluidTank.getCapacity()) : 0.0f;
    }

    @Override
    public void adoptTransmittersAndAcceptorsFrom(FluidNetwork net) {
        float oldScale = this.fluidScale;
        long oldCapacity = this.getCapacity();
        super.adoptTransmittersAndAcceptorsFrom(net);
        long capacity = this.getCapacity();
        this.fluidScale = Math.min(1.0f, capacity == 0L ? 0.0f : (this.fluidScale * (float)oldCapacity + net.fluidScale * (float)net.capacity) / (float)capacity);
        if (this.isRemote()) {
            if (this.fluidTank.isEmpty() && !net.fluidTank.isEmpty()) {
                this.fluidTank.setStack(net.getBuffer());
                net.fluidTank.setEmpty();
            }
        } else {
            if (!net.fluidTank.isEmpty()) {
                if (this.fluidTank.isEmpty()) {
                    this.fluidTank.setStack(net.getBuffer());
                } else if (this.fluidTank.isFluidEqual(net.fluidTank.getFluid())) {
                    int amount = net.fluidTank.getFluidAmount();
                    MekanismUtils.logMismatchedStackSize(this.fluidTank.growStack(amount, Action.EXECUTE), amount);
                }
                net.fluidTank.setEmpty();
            }
            if (oldScale != this.fluidScale) {
                this.needsUpdate = true;
            }
        }
    }

    @Override
    @Nonnull
    public FluidStack getBuffer() {
        return this.fluidTank.getFluid().copy();
    }

    @Override
    public void absorbBuffer(IGridTransmitter<IFluidHandler, FluidNetwork, FluidStack> transmitter) {
        FluidStack fluid = transmitter.getBuffer();
        if (fluid.isEmpty()) {
            return;
        }
        if (this.fluidTank.isEmpty()) {
            this.fluidTank.setStack(fluid.copy());
        } else if (this.fluidTank.isFluidEqual(fluid)) {
            int amount = fluid.getAmount();
            MekanismUtils.logMismatchedStackSize(this.fluidTank.growStack(amount, Action.EXECUTE), amount);
        }
    }

    @Override
    public void clampBuffer() {
        if (!this.fluidTank.isEmpty()) {
            int capacity = this.getCapacityAsInt();
            if (this.fluidTank.getFluidAmount() > capacity) {
                MekanismUtils.logMismatchedStackSize(this.fluidTank.setStackSize(capacity, Action.EXECUTE), capacity);
            }
        }
    }

    @Override
    protected synchronized void updateCapacity(IGridTransmitter<IFluidHandler, FluidNetwork, FluidStack> transmitter) {
        super.updateCapacity(transmitter);
        this.intCapacity = MathUtils.clampToInt(this.getCapacity());
    }

    @Override
    public synchronized void updateCapacity() {
        super.updateCapacity();
        this.intCapacity = MathUtils.clampToInt(this.getCapacity());
    }

    public int getCapacityAsInt() {
        return this.intCapacity;
    }

    @Override
    protected void updateSaveShares() {
        super.updateSaveShares();
        int size = this.transmittersSize();
        if (size > 0) {
            FluidStack fluidType = this.fluidTank.getFluid();
            Direction side = Direction.NORTH;
            ObjectOpenHashSet saveTargets = new ObjectOpenHashSet(size);
            for (IGridTransmitter transmitter : this.transmitters) {
                FluidTransmitterSaveTarget saveTarget = new FluidTransmitterSaveTarget(fluidType);
                saveTarget.addHandler(side, transmitter);
                saveTargets.add(saveTarget);
            }
            EmitUtils.sendToAcceptors(saveTargets, size, fluidType.getAmount(), fluidType);
            for (FluidTransmitterSaveTarget saveTarget : saveTargets) {
                saveTarget.saveShare(side);
            }
        }
    }

    private int tickEmit(@Nonnull FluidStack fluidToSend) {
        ObjectOpenHashSet availableAcceptors = new ObjectOpenHashSet();
        int totalHandlers = 0;
        Long2ObjectOpenHashMap chunkMap = new Long2ObjectOpenHashMap();
        for (Coord4D coord : this.possibleAcceptors) {
            TileEntity tile;
            EnumSet sides = (EnumSet)this.acceptorDirections.get(coord);
            if (sides == null || sides.isEmpty() || (tile = MekanismUtils.getTileEntity((IWorld)this.getWorld(), (Long2ObjectMap<IChunk>)chunkMap, coord)) == null) continue;
            FluidHandlerTarget target = new FluidHandlerTarget(fluidToSend);
            for (Direction side : sides) {
                CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side).ifPresent(acceptor -> {
                    if (PipeUtils.canFill(acceptor, fluidToSend)) {
                        target.addHandler(side, acceptor);
                    }
                });
            }
            int curHandlers = target.getHandlers().size();
            if (curHandlers <= 0) continue;
            availableAcceptors.add(target);
            totalHandlers += curHandlers;
        }
        return EmitUtils.sendToAcceptors(availableAcceptors, totalHandlers, fluidToSend.getAmount(), fluidToSend);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.isRemote()) {
            float scale = this.computeContentScale();
            if (scale != this.fluidScale) {
                this.fluidScale = scale;
                this.needsUpdate = true;
            }
            if (this.needsUpdate) {
                MinecraftForge.EVENT_BUS.post((Event)new FluidTransferEvent(this, this.lastFluid, this.fluidScale));
                this.needsUpdate = false;
            }
            if (this.fluidTank.isEmpty()) {
                this.prevTransferAmount = 0;
            } else {
                this.prevTransferAmount = this.tickEmit(this.fluidTank.getFluid());
                MekanismUtils.logMismatchedStackSize(this.fluidTank.shrinkStack(this.prevTransferAmount, Action.EXECUTE), this.prevTransferAmount);
            }
        }
    }

    public float computeContentScale() {
        float scale = (float)this.fluidTank.getFluidAmount() / (float)this.fluidTank.getCapacity();
        float ret = Math.max(this.fluidScale, scale);
        if (this.prevTransferAmount > 0 && ret < 1.0f) {
            ret = Math.min(1.0f, ret + 0.02f);
        } else if (this.prevTransferAmount <= 0 && ret > 0.0f) {
            ret = Math.max(scale, ret - 0.02f);
        }
        return ret;
    }

    public int getPrevTransferAmount() {
        return this.prevTransferAmount;
    }

    public String toString() {
        return "[FluidNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    @Override
    public ITextComponent getNeededInfo() {
        return MekanismLang.FLUID_NETWORK_NEEDED.translate(Float.valueOf((float)this.fluidTank.getNeeded() / 1000.0f));
    }

    @Override
    public ITextComponent getStoredInfo() {
        if (this.fluidTank.isEmpty()) {
            return MekanismLang.NONE.translate(new Object[0]);
        }
        return MekanismLang.NETWORK_MB_STORED.translate(this.fluidTank.getFluid(), this.fluidTank.getFluidAmount());
    }

    @Override
    public ITextComponent getFlowInfo() {
        return MekanismLang.NETWORK_MB_PER_TICK.translate(this.prevTransferAmount);
    }

    @Override
    public boolean isCompatibleWith(FluidNetwork other) {
        return super.isCompatibleWith(other) && (this.fluidTank.isEmpty() || other.fluidTank.isEmpty() || this.fluidTank.isFluidEqual(other.fluidTank.getFluid()));
    }

    @Override
    public boolean compatibleWithBuffer(@Nonnull FluidStack buffer) {
        return super.compatibleWithBuffer(buffer) && (this.fluidTank.isEmpty() || buffer.isEmpty() || this.fluidTank.isFluidEqual(buffer));
    }

    @Override
    public ITextComponent getTextComponent() {
        return MekanismLang.NETWORK_DESCRIPTION.translate(MekanismLang.FLUID_NETWORK, this.transmitters.size(), this.possibleAcceptors.size());
    }

    @Override
    @Nonnull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidTanks;
    }

    @Override
    public void onContentsChanged() {
        this.updateSaveShares = true;
        FluidStack type = this.fluidTank.getFluid();
        if (!this.lastFluid.isFluidEqual(type)) {
            this.lastFluid = type.isEmpty() ? FluidStack.EMPTY : new FluidStack(type, 1);
            this.needsUpdate = true;
        }
    }

    public void setLastFluid(@Nonnull FluidStack fluid) {
        if (fluid.isEmpty()) {
            this.fluidTank.setEmpty();
        } else {
            this.lastFluid = fluid;
            this.fluidTank.setStack(new FluidStack(fluid, 1));
        }
    }

    public static class FluidTransferEvent
    extends Event {
        public final FluidNetwork fluidNetwork;
        public final FluidStack fluidType;
        public final float fluidScale;

        public FluidTransferEvent(FluidNetwork network, @Nonnull FluidStack type, float scale) {
            this.fluidNetwork = network;
            this.fluidType = type;
            this.fluidScale = scale;
        }
    }
}

