/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transmitters;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.network.PacketTransporterUpdate;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporter;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.transmitters.TransmitterImpl;
import mekanism.common.transmitters.grid.InventoryNetwork;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TransporterImpl
extends TransmitterImpl<TileEntity, InventoryNetwork, Void>
implements ILogisticalTransporter {
    private final Int2ObjectOpenHashMap<TransporterStack> transit = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<TransporterStack> needsSync = new Int2ObjectOpenHashMap();
    private EnumColor color;
    private int nextId = 0;

    public TransporterImpl(TileEntityLogisticalTransporter transporter) {
        super(transporter);
    }

    public Collection<TransporterStack> getTransit() {
        return Collections.unmodifiableCollection(this.transit.values());
    }

    public void deleteStack(int id) {
        this.transit.remove(id);
    }

    public void addStack(int id, TransporterStack s) {
        this.transit.put(id, (Object)s);
    }

    public void writeToUpdateTag(CompoundNBT updateTag) {
        updateTag.func_74768_a("color", TransporterUtils.getColorIndex(this.getColor()));
        ListNBT stacks = new ListNBT();
        for (Int2ObjectMap.Entry entry : this.transit.int2ObjectEntrySet()) {
            CompoundNBT tagCompound = new CompoundNBT();
            tagCompound.func_74768_a("index", entry.getIntKey());
            ((TransporterStack)entry.getValue()).writeToUpdateTag(this, tagCompound);
            stacks.add((Object)tagCompound);
        }
        if (!stacks.isEmpty()) {
            updateTag.func_218657_a("Items", (INBT)stacks);
        }
    }

    public void readFromUpdateTag(CompoundNBT updateTag) {
        NBTUtils.setEnumIfPresent(updateTag, "color", TransporterUtils::readColor, this::setColor);
        this.transit.clear();
        if (updateTag.func_150297_b("Items", 9)) {
            ListNBT tagList = updateTag.func_150295_c("Items", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT compound = tagList.func_150305_b(i);
                TransporterStack stack = TransporterStack.readFromUpdate(compound);
                this.addStack(compound.func_74762_e("index"), stack);
            }
        }
    }

    public void writeToNBT(CompoundNBT nbtTags) {
        nbtTags.func_74768_a("color", TransporterUtils.getColorIndex(this.getColor()));
        ListNBT stacks = new ListNBT();
        for (TransporterStack stack : this.getTransit()) {
            CompoundNBT tagCompound = new CompoundNBT();
            stack.write(tagCompound);
            stacks.add((Object)tagCompound);
        }
        if (!stacks.isEmpty()) {
            nbtTags.func_218657_a("Items", (INBT)stacks);
        }
    }

    public void readFromNBT(CompoundNBT nbtTags) {
        NBTUtils.setEnumIfPresent(nbtTags, "color", TransporterUtils::readColor, this::setColor);
        if (nbtTags.func_150297_b("Items", 9)) {
            ListNBT tagList = nbtTags.func_150295_c("Items", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                TransporterStack stack = TransporterStack.readFromNBT(tagList.func_150305_b(i));
                this.addStack(this.nextId++, stack);
            }
        }
    }

    public void update() {
        if (this.world().field_72995_K) {
            for (TransporterStack stack : this.transit.values()) {
                stack.progress = Math.min(100, stack.progress + this.getTileEntity().tier.getSpeed());
            }
        } else if (this.getTransmitterNetwork() != null) {
            IntOpenHashSet deletes = new IntOpenHashSet();
            this.getTileEntity().pullItems();
            Coord4D coord = this.coord();
            for (Int2ObjectMap.Entry entry : this.transit.int2ObjectEntrySet()) {
                boolean tryRecalculate;
                int stackId = entry.getIntKey();
                TransporterStack stack = (TransporterStack)entry.getValue();
                if (!(stack.initiatedPath || !stack.itemStack.func_190926_b() && this.recalculate(stackId, stack, null))) {
                    deletes.add(stackId);
                    continue;
                }
                stack.progress += this.getTileEntity().tier.getSpeed();
                if (stack.progress >= 100) {
                    Coord4D prevSet = null;
                    if (stack.hasPath()) {
                        int currentIndex = stack.getPath().indexOf(coord);
                        if (currentIndex == 0) {
                            deletes.add(stackId);
                            continue;
                        }
                        Coord4D next = stack.getPath().get(currentIndex - 1);
                        if (next != null) {
                            TileEntity tile;
                            if (!stack.isFinal(this)) {
                                tile = MekanismUtils.getTileEntity((IBlockReader)this.world(), next.getPos());
                                if (stack.canInsertToTransporter(tile, stack.getSide(this), (TileEntity)this.containingTile)) {
                                    CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null).ifPresent(nextTile -> nextTile.entityEntering(stack, stack.progress % 100));
                                    deletes.add(stackId);
                                    continue;
                                }
                                prevSet = next;
                            } else if (stack.getPathType() != TransporterStack.Path.NONE && (tile = MekanismUtils.getTileEntity((IBlockReader)this.world(), next.getPos())) != null) {
                                TransitRequest.TransitResponse response = InventoryUtils.putStackInInventory(tile, TransitRequest.getFromTransport(stack), stack.getSide(this), stack.getPathType() == TransporterStack.Path.HOME);
                                ItemStack rejected = response.getRejected(stack.itemStack);
                                if (rejected.func_190926_b()) {
                                    TransporterManager.remove(stack);
                                    deletes.add(stackId);
                                    continue;
                                }
                                stack.itemStack = rejected;
                                prevSet = next;
                            }
                        }
                    }
                    if (!this.recalculate(stackId, stack, prevSet)) {
                        deletes.add(stackId);
                        continue;
                    }
                    if (prevSet != null) {
                        stack.progress = 0;
                        continue;
                    }
                    stack.progress = 50;
                    continue;
                }
                if (stack.progress != 50) continue;
                if (stack.isFinal(this)) {
                    tryRecalculate = this.checkPath(stack, TransporterStack.Path.DEST, false) || this.checkPath(stack, TransporterStack.Path.HOME, true) || stack.getPathType() == TransporterStack.Path.NONE;
                } else {
                    boolean bl = tryRecalculate = !stack.canInsertToTransporter(MekanismUtils.getTileEntity((IBlockReader)this.world(), stack.getNext(this).getPos()), stack.getSide(this), (TileEntity)this.containingTile);
                }
                if (!tryRecalculate || this.recalculate(stackId, stack, null)) continue;
                deletes.add(stackId);
            }
            if (!deletes.isEmpty() || !this.needsSync.isEmpty()) {
                Mekanism.packetHandler.sendToAllTracking(new PacketTransporterUpdate(this.getTileEntity(), this.needsSync, (IntSet)deletes), this.world(), coord.getPos());
                deletes.forEach(this::deleteStack);
                this.needsSync.clear();
                MekanismUtils.saveChunk(this.getTileEntity());
            }
        }
    }

    private boolean checkPath(TransporterStack stack, TransporterStack.Path dest, boolean home) {
        return stack.getPathType() == dest && (!this.checkSideForInsert(stack) || !InventoryUtils.canInsert(MekanismUtils.getTileEntity((IBlockReader)this.world(), stack.getDest().getPos()), stack.color, stack.itemStack, stack.getSide(this), home));
    }

    private boolean checkSideForInsert(TransporterStack stack) {
        Direction side = stack.getSide(this);
        return this.getTileEntity().getConnectionType(side) == TileEntitySidedPipe.ConnectionType.NORMAL || this.getTileEntity().getConnectionType(side) == TileEntitySidedPipe.ConnectionType.PUSH;
    }

    private boolean recalculate(int stackId, TransporterStack stack, Coord4D from) {
        boolean noPath;
        boolean bl = noPath = stack.getPathType() == TransporterStack.Path.NONE;
        if (!noPath) {
            noPath = stack.recalculatePath(TransitRequest.getFromTransport(stack), this, 0).isEmpty();
        }
        if (noPath && !stack.calculateIdle(this)) {
            TransporterUtils.drop(this, stack);
            return false;
        }
        this.needsSync.put(stackId, (Object)stack);
        if (from != null) {
            stack.originalLocation = from;
        }
        return true;
    }

    @Override
    public TransitRequest.TransitResponse insert(TileEntity outputter, TransitRequest request, EnumColor color, boolean doEmit, int min) {
        Coord4D original = Coord4D.get(outputter);
        Direction from = this.coord().sideDifference(original).func_176734_d();
        TransporterStack stack = new TransporterStack();
        stack.originalLocation = original;
        stack.homeLocation = original;
        stack.color = color;
        if (!stack.canInsertToTransporter(this, from, outputter)) {
            return request.getEmptyResponse();
        }
        TransitRequest.TransitResponse response = stack.recalculatePath(request, this, min);
        return this.updateTransit(doEmit, stack, response);
    }

    @Nonnull
    private TransitRequest.TransitResponse updateTransit(boolean doEmit, TransporterStack stack, TransitRequest.TransitResponse response) {
        if (!response.isEmpty()) {
            stack.itemStack = response.getStack();
            if (doEmit) {
                int stackId = this.nextId++;
                this.addStack(stackId, stack);
                TileEntityLogisticalTransporter tile = this.getTileEntity();
                Mekanism.packetHandler.sendToAllTracking(new PacketTransporterUpdate(tile, stackId, stack), tile);
                MekanismUtils.saveChunk(tile);
            }
        }
        return response;
    }

    @Override
    public TransitRequest.TransitResponse insertRR(TileEntityLogisticalSorter outputter, TransitRequest request, EnumColor color, boolean doEmit, int min) {
        Direction from = this.coord().sideDifference(Coord4D.get(outputter)).func_176734_d();
        TransporterStack stack = new TransporterStack();
        stack.originalLocation = Coord4D.get(outputter);
        stack.homeLocation = Coord4D.get(outputter);
        stack.color = color;
        if (!this.canReceiveFrom(outputter, from) || !stack.canInsertToTransporter(this, from, (TileEntity)outputter)) {
            return request.getEmptyResponse();
        }
        TransitRequest.TransitResponse response = stack.recalculateRRPath(request, outputter, this, min);
        return this.updateTransit(doEmit, stack, response);
    }

    @Override
    public void entityEntering(TransporterStack stack, int progress) {
        int stackId = this.nextId++;
        stack.progress = progress;
        this.addStack(stackId, stack);
        this.needsSync.put(stackId, (Object)stack);
    }

    @Override
    public EnumColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(EnumColor c) {
        this.color = c;
    }

    @Override
    public boolean canEmitTo(TileEntity tile, Direction side) {
        if (!this.getTileEntity().canConnect(side)) {
            return false;
        }
        return this.getTileEntity().getConnectionType(side) == TileEntitySidedPipe.ConnectionType.NORMAL || this.getTileEntity().getConnectionType(side) == TileEntitySidedPipe.ConnectionType.PUSH;
    }

    @Override
    public boolean canReceiveFrom(TileEntity tile, Direction side) {
        if (!this.getTileEntity().canConnect(side)) {
            return false;
        }
        return this.getTileEntity().getConnectionType(side) == TileEntitySidedPipe.ConnectionType.NORMAL;
    }

    @Override
    public double getCost() {
        return this.getTileEntity().getCost();
    }

    @Override
    public boolean canConnectMutual(Direction side, @Nullable TileEntity cachedTile) {
        return this.getTileEntity().canConnectMutual(side, cachedTile);
    }

    @Override
    public boolean canConnect(Direction side) {
        return this.getTileEntity().canConnect(side);
    }

    public TileEntityLogisticalTransporter getTileEntity() {
        return (TileEntityLogisticalTransporter)this.containingTile;
    }
}

