/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import javax.annotation.Nonnull;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.Mekanism;
import mekanism.common.content.matrix.MatrixCache;
import mekanism.common.content.matrix.MatrixUpdateProtocol;
import mekanism.common.content.matrix.SynchronizedMatrixData;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.TileEntityMultiblock;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityInductionCasing
extends TileEntityMultiblock<SynchronizedMatrixData> {
    public TileEntityInductionCasing() {
        this(MekanismBlocks.INDUCTION_CASING);
        this.addDisabledCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    public TileEntityInductionCasing(IBlockProvider blockProvider) {
        super(blockProvider);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.structure != null && this.isRendering) {
            ((SynchronizedMatrixData)this.structure).tick();
            ((SynchronizedMatrixData)this.structure).energyInputSlot.drainContainer();
            ((SynchronizedMatrixData)this.structure).energyOutputSlot.fillContainerOrConvert();
            if (!((SynchronizedMatrixData)this.structure).getLastInput().isZero() || !((SynchronizedMatrixData)this.structure).getLastOutput().isZero()) {
                ((SynchronizedMatrixData)this.structure).markDirtyComparator(this.field_145850_b);
            }
        }
    }

    @Override
    @Nonnull
    protected SynchronizedMatrixData getNewStructure() {
        return new SynchronizedMatrixData(this);
    }

    public MatrixCache getNewCache() {
        return new MatrixCache();
    }

    protected MatrixUpdateProtocol getProtocol() {
        return new MatrixUpdateProtocol(this);
    }

    @Override
    public MultiblockManager<SynchronizedMatrixData> getManager() {
        return Mekanism.matrixManager;
    }

    public FloatingLong getEnergy() {
        return this.structure == null ? FloatingLong.ZERO : ((SynchronizedMatrixData)this.structure).getEnergy();
    }

    public FloatingLong getMaxEnergy() {
        return this.structure == null ? FloatingLong.ZERO : ((SynchronizedMatrixData)this.structure).getStorageCap();
    }

    public FloatingLong getLastInput() {
        return this.structure == null ? FloatingLong.ZERO : ((SynchronizedMatrixData)this.structure).getLastInput();
    }

    public FloatingLong getLastOutput() {
        return this.structure == null ? FloatingLong.ZERO : ((SynchronizedMatrixData)this.structure).getLastOutput();
    }

    public FloatingLong getTransferCap() {
        return this.structure == null ? FloatingLong.ZERO : ((SynchronizedMatrixData)this.structure).getTransferCap();
    }

    public int getCellCount() {
        return this.structure == null ? 0 : ((SynchronizedMatrixData)this.structure).getCellCount();
    }

    public int getProviderCount() {
        return this.structure == null ? 0 : ((SynchronizedMatrixData)this.structure).getProviderCount();
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableFloatingLong.create(this::getEnergy, value -> {
            if (this.structure != null) {
                ((SynchronizedMatrixData)this.structure).setClientEnergy((FloatingLong)value);
            }
        }));
        container.track(SyncableFloatingLong.create(this::getMaxEnergy, value -> {
            if (this.structure != null) {
                ((SynchronizedMatrixData)this.structure).setClientMaxEnergy((FloatingLong)value);
            }
        }));
        container.track(SyncableFloatingLong.create(this::getLastInput, value -> {
            if (this.structure != null) {
                ((SynchronizedMatrixData)this.structure).setClientLastInput((FloatingLong)value);
            }
        }));
        container.track(SyncableFloatingLong.create(this::getLastOutput, value -> {
            if (this.structure != null) {
                ((SynchronizedMatrixData)this.structure).setClientLastOutput((FloatingLong)value);
            }
        }));
    }

    public void addStatsTabContainerTrackers(MekanismContainer container) {
        container.track(SyncableFloatingLong.create(() -> this.structure == null ? FloatingLong.ZERO : ((SynchronizedMatrixData)this.structure).getTransferCap(), value -> {
            if (this.structure != null) {
                ((SynchronizedMatrixData)this.structure).setClientMaxTransfer((FloatingLong)value);
            }
        }));
        container.track(SyncableInt.create(() -> this.structure == null ? 0 : ((SynchronizedMatrixData)this.structure).volHeight, value -> {
            if (this.structure != null) {
                ((SynchronizedMatrixData)this.structure).volHeight = value;
            }
        }));
        container.track(SyncableInt.create(() -> this.structure == null ? 0 : ((SynchronizedMatrixData)this.structure).volWidth, value -> {
            if (this.structure != null) {
                ((SynchronizedMatrixData)this.structure).volWidth = value;
            }
        }));
        container.track(SyncableInt.create(() -> this.structure == null ? 0 : ((SynchronizedMatrixData)this.structure).volLength, value -> {
            if (this.structure != null) {
                ((SynchronizedMatrixData)this.structure).volLength = value;
            }
        }));
        container.track(SyncableInt.create(() -> this.structure == null ? 0 : ((SynchronizedMatrixData)this.structure).getCellCount(), value -> {
            if (this.structure != null) {
                ((SynchronizedMatrixData)this.structure).setClientCells(value);
            }
        }));
        container.track(SyncableInt.create(() -> this.structure == null ? 0 : ((SynchronizedMatrixData)this.structure).getProviderCount(), value -> {
            if (this.structure != null) {
                ((SynchronizedMatrixData)this.structure).setClientProviders(value);
            }
        }));
    }
}

