/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block.machine;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.text.EnumColor;
import mekanism.client.render.item.ISTERProvider;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.basic.BlockFluidTank;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.fluid.item.RateLimitFluidHandler;
import mekanism.common.item.IItemSustainedInventory;
import mekanism.common.item.IModeItem;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.security.ISecurityItem;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class ItemBlockFluidTank
extends ItemBlockTooltip<BlockFluidTank>
implements IItemSustainedInventory,
ISecurityItem,
IModeItem {
    public ItemBlockFluidTank(BlockFluidTank block) {
        super(block, true, ItemDeferredRegister.getMekBaseProperties().func_200917_a(1).setISTER(ISTERProvider::fluidTank));
    }

    @Nonnull
    public FluidTankTier getTier() {
        return Attribute.getTier(this.func_179223_d(), FluidTankTier.class);
    }

    @Override
    public void addStats(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, boolean advanced) {
        FluidTankTier tier = this.getTier();
        FluidStack fluidStack = StorageUtils.getStoredFluidFromNBT(stack);
        if (fluidStack.isEmpty()) {
            tooltip.add(MekanismLang.EMPTY.translateColored(EnumColor.DARK_RED, new Object[0]));
        } else if (tier == FluidTankTier.CREATIVE) {
            tooltip.add(MekanismLang.GENERIC_STORED.translateColored(EnumColor.PINK, new Object[]{fluidStack, EnumColor.GRAY, MekanismLang.INFINITE}));
        } else {
            tooltip.add(MekanismLang.GENERIC_STORED_MB.translateColored(EnumColor.PINK, new Object[]{fluidStack, EnumColor.GRAY, fluidStack.getAmount()}));
        }
        if (tier == FluidTankTier.CREATIVE) {
            tooltip.add(MekanismLang.CAPACITY.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, MekanismLang.INFINITE}));
        } else {
            tooltip.add(MekanismLang.CAPACITY_MB.translateColored(EnumColor.INDIGO, new Object[]{EnumColor.GRAY, tier.getStorage()}));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addDetails(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, boolean advanced) {
        tooltip.add(OwnerDisplay.of((PlayerEntity)Minecraft.func_71410_x().field_71439_g, this.getOwnerUUID(stack)).getTextComponent());
        tooltip.add(MekanismLang.SECURITY.translateColored(EnumColor.GRAY, SecurityUtils.getSecurity(stack, Dist.CLIENT)));
        if (SecurityUtils.isOverridden(stack, Dist.CLIENT)) {
            tooltip.add(MekanismLang.SECURITY_OVERRIDDEN.translateColored(EnumColor.RED, new Object[0]));
        }
        tooltip.add(MekanismLang.BUCKET_MODE.translateColored(EnumColor.INDIGO, BooleanStateDisplay.YesNo.of(this.getBucketMode(stack))));
        tooltip.add(MekanismLang.HAS_INVENTORY.translateColored(EnumColor.AQUA, new Object[]{EnumColor.GRAY, BooleanStateDisplay.YesNo.of(this.hasInventory(new Object[]{stack}))}));
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        ItemStack stack = player.func_184586_b(context.func_221531_n());
        if (this.getBucketMode(stack)) {
            return ActionResultType.PASS;
        }
        return super.func_195939_a(context);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.getBucketMode(stack)) {
            if (SecurityUtils.canAccess(player, stack)) {
                RayTraceResult rayTraceResult = ItemBlockFluidTank.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)(!player.func_225608_bj_() ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE));
                if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    BlockRayTraceResult result = (BlockRayTraceResult)rayTraceResult;
                    BlockPos pos = result.func_216350_a();
                    if (!world.func_175660_a(player, pos)) {
                        return new ActionResult(ActionResultType.FAIL, (Object)stack);
                    }
                    Optional capability = MekanismUtils.toOptional(FluidUtil.getFluidHandler((ItemStack)stack));
                    if (!capability.isPresent()) {
                        return new ActionResult(ActionResultType.FAIL, (Object)stack);
                    }
                    IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)capability.get();
                    if (!(fluidHandlerItem instanceof IMekanismFluidHandler)) {
                        return new ActionResult(ActionResultType.FAIL, (Object)stack);
                    }
                    IExtendedFluidTank fluidTank = ((IMekanismFluidHandler)fluidHandlerItem).getFluidTank(0, null);
                    if (fluidTank == null) {
                        return new ActionResult(ActionResultType.FAIL, (Object)stack);
                    }
                    if (!player.func_225608_bj_()) {
                        if (!player.func_175151_a(pos, result.func_216354_b(), stack)) {
                            return new ActionResult(ActionResultType.FAIL, (Object)stack);
                        }
                        IFluidState fluidState = world.func_204610_c(pos);
                        if (!fluidState.func_206888_e() && fluidState.func_206889_d()) {
                            Fluid fluid = fluidState.func_206886_c();
                            FluidStack fluidStack = new FluidStack(fluid, 1000);
                            BlockState blockState = world.func_180495_p(pos);
                            Block block = blockState.func_177230_c();
                            if (block instanceof IFluidBlock) {
                                fluidStack = ((IFluidBlock)block).drain(world, pos, IFluidHandler.FluidAction.SIMULATE);
                                if (!this.validFluid(fluidTank, fluidStack)) {
                                    return new ActionResult(ActionResultType.PASS, (Object)stack);
                                }
                                fluidStack = ((IFluidBlock)block).drain(world, pos, IFluidHandler.FluidAction.EXECUTE);
                            } else if (block instanceof IBucketPickupHandler && this.validFluid(fluidTank, fluidStack) && !this.validFluid(fluidTank, fluidStack = new FluidStack(fluid = ((IBucketPickupHandler)block).func_204508_a((IWorld)world, pos, blockState), 1000))) {
                                Mekanism.logger.warn("Fluid removed without successfully picking up. Fluid {} at {} in {} was valid, but after picking up was {}.", (Object)fluidState.func_206886_c(), (Object)pos, (Object)world, (Object)fluid);
                                return new ActionResult(ActionResultType.FAIL, (Object)stack);
                            }
                            if (this.validFluid(fluidTank, fluidStack)) {
                                if (fluidTank.isEmpty()) {
                                    fluidTank.setStack(fluidStack);
                                } else {
                                    MekanismUtils.logMismatchedStackSize(fluidTank.growStack(fluidStack.getAmount(), Action.EXECUTE), fluidStack.getAmount());
                                }
                                return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
                            }
                            return new ActionResult(ActionResultType.FAIL, (Object)stack);
                        }
                    } else {
                        if (fluidTank.extract(1000, Action.SIMULATE, AutomationType.MANUAL).getAmount() < 1000 || !player.func_175151_a(pos.func_177972_a(result.func_216354_b()), result.func_216354_b(), stack)) {
                            return new ActionResult(ActionResultType.FAIL, (Object)stack);
                        }
                        if (MekanismUtils.tryPlaceContainedLiquid(player, world, pos, fluidHandlerItem.getFluidInTank(0), result.func_216354_b())) {
                            if (!player.func_184812_l_()) {
                                MekanismUtils.logMismatchedStackSize(fluidTank.shrinkStack(1000, Action.EXECUTE), 1000L);
                            }
                            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
                        }
                    }
                }
            } else {
                SecurityUtils.displayNoAccess(player);
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    private boolean validFluid(@Nonnull IExtendedFluidTank fluidTank, @Nonnull FluidStack fluidStack) {
        return !fluidStack.isEmpty() && fluidTank.insert(fluidStack, Action.SIMULATE, AutomationType.MANUAL).isEmpty();
    }

    public void setBucketMode(ItemStack itemStack, boolean bucketMode) {
        ItemDataUtils.setBoolean(itemStack, "bucketMode", bucketMode);
    }

    public boolean getBucketMode(ItemStack itemStack) {
        return ItemDataUtils.getBoolean(itemStack, "bucketMode");
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new ItemCapabilityWrapper(stack, RateLimitFluidHandler.create(this.getTier()));
    }

    @Override
    public void changeMode(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
        if (Math.abs(shift) % 2 == 1) {
            boolean newState = !this.getBucketMode(stack);
            this.setBucketMode(stack, newState);
            if (displayChangeMessage) {
                player.func_145747_a(MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, MekanismLang.BUCKET_MODE.translateColored(EnumColor.GRAY, BooleanStateDisplay.OnOff.of(newState, true))));
            }
        }
    }

    @Override
    @Nonnull
    public ITextComponent getScrollTextComponent(@Nonnull ItemStack stack) {
        return MekanismLang.BUCKET_MODE.translateColored(EnumColor.GRAY, BooleanStateDisplay.OnOff.of(this.getBucketMode(stack), true));
    }
}

