/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.api.MekanismAPI;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.ItemEnergized;
import mekanism.common.transmitters.grid.EnergyNetwork;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.TextComponentUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemNetworkReader
extends ItemEnergized {
    public ItemNetworkReader(Item.Properties properties) {
        super(MekanismConfig.gear.networkReaderChargeRate, MekanismConfig.gear.networkReaderMaxEnergy, properties);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        if (!world.field_72995_K && player != null) {
            ItemStack stack = player.func_184586_b(context.func_221531_n());
            BlockPos pos = context.func_195995_a();
            TileEntity tileEntity = MekanismUtils.getTileEntity((IBlockReader)world, pos);
            if (tileEntity != null) {
                Direction opposite;
                Optional<IGridTransmitter<?, ?, ?>> gridTransmitter;
                if (!player.func_184812_l_()) {
                    FloatingLong energyPerUse = (FloatingLong)MekanismConfig.gear.networkReaderEnergyUsage.get();
                    IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                    if (energyContainer == null || energyContainer.extract(energyPerUse, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyPerUse)) {
                        return ActionResultType.FAIL;
                    }
                    energyContainer.extract(energyPerUse, Action.EXECUTE, AutomationType.MANUAL);
                }
                if ((gridTransmitter = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, opposite = context.func_196000_l().func_176734_d()))).isPresent()) {
                    IGridTransmitter<?, ?, ?> transmitter = gridTransmitter.get();
                    player.func_145747_a(MekanismLang.NETWORK_READER_BORDER.translateColored(EnumColor.GRAY, "-------------", MekanismLang.GENERIC_SQUARE_BRACKET.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM)));
                    player.func_145747_a(MekanismLang.NETWORK_READER_TRANSMITTERS.translateColored(EnumColor.GRAY, new Object[]{EnumColor.DARK_GRAY, transmitter.getTransmitterNetworkSize()}));
                    player.func_145747_a(MekanismLang.NETWORK_READER_ACCEPTORS.translateColored(EnumColor.GRAY, new Object[]{EnumColor.DARK_GRAY, transmitter.getTransmitterNetworkAcceptorSize()}));
                    player.func_145747_a(MekanismLang.NETWORK_READER_NEEDED.translateColored(EnumColor.GRAY, new Object[]{EnumColor.DARK_GRAY, transmitter.getTransmitterNetworkNeeded()}));
                    player.func_145747_a(MekanismLang.NETWORK_READER_BUFFER.translateColored(EnumColor.GRAY, new Object[]{EnumColor.DARK_GRAY, transmitter.getTransmitterNetworkBuffer()}));
                    player.func_145747_a(MekanismLang.NETWORK_READER_THROUGHPUT.translateColored(EnumColor.GRAY, new Object[]{EnumColor.DARK_GRAY, transmitter.getTransmitterNetworkFlow()}));
                    Object transmitterNetwork = transmitter.getTransmitterNetwork();
                    if (transmitterNetwork instanceof EnergyNetwork) {
                        player.func_145747_a(MekanismLang.NETWORK_READER_CAPACITY.translateColored(EnumColor.GRAY, new Object[]{EnumColor.DARK_GRAY, ((EnergyNetwork)transmitterNetwork).getCapacityAsFloatingLong()}));
                    } else {
                        player.func_145747_a(MekanismLang.NETWORK_READER_CAPACITY.translateColored(EnumColor.GRAY, new Object[]{EnumColor.DARK_GRAY, transmitter.getTransmitterNetworkCapacity()}));
                    }
                    CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.HEAT_HANDLER_CAPABILITY, opposite).ifPresent(heatHandler -> player.func_145747_a(MekanismLang.NETWORK_READER_TEMPERATURE.translateColored(EnumColor.GRAY, new Object[]{EnumColor.DARK_GRAY, MekanismUtils.getTemperatureDisplay(heatHandler.getTotalTemperature(), UnitDisplayUtils.TemperatureUnit.KELVIN, true)})));
                    player.func_145747_a(MekanismLang.NETWORK_READER_BORDER.translateColored(EnumColor.GRAY, new Object[]{"-------------", EnumColor.DARK_BLUE, "[=======]"}));
                } else {
                    Optional<IHeatHandler> heatHandler2 = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.HEAT_HANDLER_CAPABILITY, opposite));
                    if (heatHandler2.isPresent()) {
                        IHeatHandler transfer = heatHandler2.get();
                        MekanismLang.NETWORK_READER_BORDER.translateColored(EnumColor.GRAY, "-------------", MekanismLang.GENERIC_SQUARE_BRACKET.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM));
                        ITextComponent temp = MekanismUtils.getTemperatureDisplay(transfer.getTotalTemperature(), UnitDisplayUtils.TemperatureUnit.KELVIN, true);
                        player.func_145747_a(MekanismLang.NETWORK_READER_TEMPERATURE.translateColored(EnumColor.GRAY, new Object[]{EnumColor.DARK_GRAY, temp}));
                        player.func_145747_a(MekanismLang.NETWORK_READER_BORDER.translateColored(EnumColor.GRAY, new Object[]{"-------------", EnumColor.DARK_BLUE, "[=======]"}));
                    } else {
                        Coord4D tileCoord = Coord4D.get(tileEntity);
                        ObjectOpenHashSet iteratedNetworks = new ObjectOpenHashSet();
                        for (Direction side : EnumUtils.DIRECTIONS) {
                            TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)world, pos.func_177972_a(side));
                            CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d()).ifPresent(arg_0 -> this.lambda$onItemUse$1(tileCoord, (Set)iteratedNetworks, player, arg_0));
                        }
                    }
                }
                return ActionResultType.SUCCESS;
            }
            if (player.func_225608_bj_() && MekanismAPI.debug) {
                MekanismLang.NETWORK_READER_BORDER.translateColored(EnumColor.GRAY, "----------", MekanismLang.GENERIC_SQUARE_BRACKET.translateColored(EnumColor.DARK_BLUE, MekanismLang.DEBUG_TITLE));
                for (ITextComponent component : TransmitterNetworkRegistry.getInstance().toComponents()) {
                    player.func_145747_a(TextComponentUtil.build(new Object[]{EnumColor.DARK_GRAY, component}));
                }
                player.func_145747_a(MekanismLang.NETWORK_READER_BORDER.translateColored(EnumColor.GRAY, new Object[]{"-------------", EnumColor.DARK_BLUE, "[=======]"}));
            }
        }
        return ActionResultType.PASS;
    }

    private ITextComponent getDirections(Set<Direction> directions) {
        if (directions.isEmpty()) {
            return MekanismLang.GENERIC_SQUARE_BRACKET.translate("");
        }
        ITextComponent component = null;
        for (Direction direction : directions) {
            if (component == null) {
                component = TextComponentUtil.build(direction);
                continue;
            }
            component = MekanismLang.GENERIC_WITH_COMMA.translate(component, direction);
        }
        return MekanismLang.GENERIC_SQUARE_BRACKET.translate(component);
    }

    private /* synthetic */ void lambda$onItemUse$1(Coord4D tileCoord, Set iteratedNetworks, PlayerEntity player, IGridTransmitter transmitter) {
        Object transmitterNetwork = transmitter.getTransmitterNetwork();
        if (((DynamicNetwork)transmitterNetwork).getPossibleAcceptors().contains(tileCoord) && !iteratedNetworks.contains(transmitterNetwork)) {
            player.func_145747_a(MekanismLang.NETWORK_READER_BORDER.translateColored(EnumColor.GRAY, "-------------", MekanismLang.GENERIC_SQUARE_BRACKET.translateColored(EnumColor.DARK_BLUE, transmitter.getTransmissionType())));
            player.func_145747_a(MekanismLang.NETWORK_READER_CONNECTED_SIDES.translateColored(EnumColor.GRAY, new Object[]{EnumColor.DARK_GRAY, this.getDirections((Set<Direction>)((DynamicNetwork)transmitterNetwork).getAcceptorDirections().get(tileCoord))}));
            player.func_145747_a(MekanismLang.NETWORK_READER_BORDER.translateColored(EnumColor.GRAY, new Object[]{"-------------", EnumColor.DARK_BLUE, "[=======]"}));
            iteratedNetworks.add(transmitterNetwork);
        }
    }
}

