/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableChemicalStack;
import mekanism.common.network.container.property.InfusionStackPropertyData;
import mekanism.common.network.container.property.LongPropertyData;
import mekanism.common.network.container.property.PropertyData;

public class SyncableInfusionStack
extends SyncableChemicalStack<InfuseType, InfusionStack> {
    public static SyncableInfusionStack create(IInfusionTank handler) {
        return new SyncableInfusionStack(handler::getStack, handler::setStack);
    }

    public static SyncableInfusionStack create(Supplier<@NonNull InfusionStack> getter, Consumer<@NonNull InfusionStack> setter) {
        return new SyncableInfusionStack(getter, setter);
    }

    private SyncableInfusionStack(Supplier<@NonNull InfusionStack> getter, Consumer<@NonNull InfusionStack> setter) {
        super(getter, setter);
    }

    @Override
    @Nonnull
    protected InfusionStack getEmptyStack() {
        return InfusionStack.EMPTY;
    }

    @Override
    @Nonnull
    protected InfusionStack createStack(InfusionStack stored, long size) {
        return new InfusionStack(stored, size);
    }

    @Override
    public PropertyData getPropertyData(short property, ISyncableData.DirtyType dirtyType) {
        if (dirtyType == ISyncableData.DirtyType.SIZE) {
            return new LongPropertyData(property, ((InfusionStack)this.get()).getAmount());
        }
        return new InfusionStackPropertyData(property, (InfusionStack)this.get());
    }
}

