/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync;

import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.network.container.property.DoublePropertyData;

public abstract class SyncableDouble
implements ISyncableData {
    private double lastKnownValue;

    public abstract double get();

    public abstract void set(double var1);

    @Override
    public ISyncableData.DirtyType isDirty() {
        double oldValue = this.get();
        boolean dirty = oldValue != this.lastKnownValue;
        this.lastKnownValue = oldValue;
        return ISyncableData.DirtyType.get(dirty);
    }

    @Override
    public DoublePropertyData getPropertyData(short property, ISyncableData.DirtyType dirtyType) {
        return new DoublePropertyData(property, this.get());
    }

    public static SyncableDouble create(final double[] doubleArray, final int idx) {
        return new SyncableDouble(){

            @Override
            public double get() {
                return doubleArray[idx];
            }

            @Override
            public void set(double value) {
                doubleArray[idx] = value;
            }
        };
    }

    public static SyncableDouble create(final DoubleSupplier getter, final DoubleConsumer setter) {
        return new SyncableDouble(){

            @Override
            public double get() {
                return getter.getAsDouble();
            }

            @Override
            public void set(double value) {
                setter.accept(value);
            }
        };
    }
}

