/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.theoneprobe;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.integration.theoneprobe.TOPElement;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public class FluidElement
extends TOPElement {
    public static int ID;
    @Nonnull
    protected final FluidStack stored;
    protected final int capacity;

    public FluidElement(@Nonnull FluidStack stored, int capacity) {
        super(-16777216, 0xFFFFFF);
        this.stored = stored;
        this.capacity = capacity;
    }

    public FluidElement(PacketBuffer buf) {
        this(buf.readFluidStack(), buf.func_150792_a());
    }

    public void toBytes(PacketBuffer buf) {
        new PacketBuffer((ByteBuf)buf).writeFluidStack(this.stored);
        buf.func_150787_b(this.capacity);
    }

    @Override
    public int getScaledLevel(int level) {
        if (this.capacity == 0 || this.stored.getAmount() == Integer.MAX_VALUE) {
            return level;
        }
        return this.stored.getAmount() * level / this.capacity;
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return this.stored.isEmpty() ? null : MekanismRenderer.getFluidTexture(this.stored, MekanismRenderer.FluidType.STILL);
    }

    @Override
    public ITextComponent getText() {
        int amount = this.stored.getAmount();
        if (amount == Integer.MAX_VALUE) {
            return MekanismLang.GENERIC_STORED.translate(this.stored, MekanismLang.INFINITE);
        }
        return MekanismLang.GENERIC_STORED_MB.translate(this.stored, amount);
    }

    @Override
    protected boolean applyRenderColor() {
        MekanismRenderer.color(this.stored);
        return true;
    }

    public int getID() {
        return ID;
    }
}

