/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import mekanism.common.content.transporter.Finder;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class StackSearcher {
    private int slotCount = -1;
    private TileEntity tile;
    private Direction side;

    public StackSearcher(TileEntity tile, Direction direction) {
        this.tile = tile;
        this.side = direction;
        CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).ifPresent(itemHandler -> {
            this.slotCount = itemHandler.getSlots();
        });
    }

    public InvStack takeTopStack(Finder id, int amount) {
        IItemHandler inventory = InventoryUtils.assertItemHandler("StackSearcher", this.tile, this.side.func_176734_d());
        if (inventory == null) {
            return null;
        }
        --this.slotCount;
        while (this.slotCount >= 0) {
            ItemStack stack = inventory.extractItem(this.slotCount, amount, true);
            if (!stack.func_190926_b() && id.modifies(stack)) {
                return new InvStack(this.tile, this.slotCount, stack, this.side.func_176734_d());
            }
            --this.slotCount;
        }
        return null;
    }

    public InvStack takeDefinedItem(ItemStack type, int min, int max) {
        IItemHandler inventory = InventoryUtils.assertItemHandler("StackSearcher", this.tile, this.side.func_176734_d());
        if (inventory == null) {
            return null;
        }
        InvStack ret = new InvStack(this.tile, this.side.func_176734_d());
        --this.slotCount;
        while (this.slotCount >= 0) {
            ItemStack stack = inventory.extractItem(this.slotCount, max, true);
            if (!stack.func_190926_b() && ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)type)) {
                int current = ret.getStack().func_190916_E();
                if (current + stack.func_190916_E() <= max) {
                    ret.appendStack(this.slotCount, stack.func_77946_l());
                } else {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190920_e(max - current);
                    ret.appendStack(this.slotCount, copy);
                }
                if (!ret.getStack().func_190926_b() && ret.getStack().func_190916_E() == max) {
                    return ret;
                }
            }
            --this.slotCount;
        }
        if (!ret.getStack().func_190926_b() && ret.getStack().func_190916_E() >= min) {
            return ret;
        }
        return null;
    }

    public int getSlotCount() {
        return this.slotCount;
    }
}

