/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.resolver.manager;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.common.capabilities.holder.IHolder;
import mekanism.common.capabilities.resolver.manager.ICapabilityHandlerManager;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CapabilityHandlerManager<HOLDER extends IHolder, CONTAINER, HANDLER, SIDED_HANDLER extends HANDLER>
implements ICapabilityHandlerManager<CONTAINER> {
    private final ProxyCreator<HANDLER, SIDED_HANDLER> proxyCreator;
    private final BiFunction<HOLDER, Direction, List<CONTAINER>> containerGetter;
    private final Map<Direction, LazyOptional<HANDLER>> handlers;
    private final List<Capability<?>> supportedCapability;
    private final SIDED_HANDLER baseHandler;
    private final boolean canHandle;
    @Nullable
    private LazyOptional<HANDLER> readOnlyHandler;
    @Nullable
    protected final HOLDER holder;

    protected CapabilityHandlerManager(@Nullable HOLDER holder, SIDED_HANDLER baseHandler, Capability<HANDLER> supportedCapability, ProxyCreator<HANDLER, SIDED_HANDLER> proxyCreator, BiFunction<HOLDER, Direction, List<CONTAINER>> containerGetter) {
        this(holder, true, baseHandler, supportedCapability, proxyCreator, containerGetter);
    }

    protected CapabilityHandlerManager(@Nullable HOLDER holder, boolean canHandle, SIDED_HANDLER baseHandler, Capability<HANDLER> supportedCapability, ProxyCreator<HANDLER, SIDED_HANDLER> proxyCreator, BiFunction<HOLDER, Direction, List<CONTAINER>> containerGetter) {
        this.supportedCapability = Collections.singletonList(supportedCapability);
        this.holder = holder;
        this.canHandle = canHandle && this.holder != null;
        this.baseHandler = baseHandler;
        this.proxyCreator = proxyCreator;
        this.containerGetter = containerGetter;
        this.handlers = this.canHandle ? new EnumMap<Direction, LazyOptional<HANDLER>>(Direction.class) : Collections.emptyMap();
    }

    @Override
    public boolean canHandle() {
        return this.canHandle;
    }

    @Override
    public List<CONTAINER> getContainers(@Nullable Direction side) {
        return this.canHandle() ? this.containerGetter.apply(this.holder, side) : Collections.emptyList();
    }

    @Override
    public List<Capability<?>> getSupportedCapabilities() {
        return this.supportedCapability;
    }

    @Override
    public <T> LazyOptional<T> resolve(Capability<T> capability, @Nullable Direction side) {
        if (this.getContainers(side).isEmpty()) {
            return LazyOptional.empty();
        }
        if (side == null) {
            if (this.readOnlyHandler == null || !this.readOnlyHandler.isPresent()) {
                this.readOnlyHandler = LazyOptional.of(() -> this.proxyCreator.create(this.baseHandler, null, (IHolder)this.holder));
            }
            return this.readOnlyHandler.cast();
        }
        LazyOptional cachedCapability = this.handlers.get(side);
        if (cachedCapability == null || !cachedCapability.isPresent()) {
            cachedCapability = LazyOptional.of(() -> this.proxyCreator.create(this.baseHandler, side, (IHolder)this.holder));
            this.handlers.put(side, cachedCapability);
        }
        return cachedCapability.cast();
    }

    @Override
    public void invalidate(Capability<?> capability, @Nullable Direction side) {
        if (side == null) {
            this.invalidateReadOnly();
        } else {
            this.invalidate(this.handlers.get(side));
        }
    }

    @Override
    public void invalidateAll() {
        this.invalidateReadOnly();
        this.handlers.values().forEach(this::invalidate);
    }

    private void invalidateReadOnly() {
        if (this.readOnlyHandler != null && this.readOnlyHandler.isPresent()) {
            this.readOnlyHandler.invalidate();
            this.readOnlyHandler = null;
        }
    }

    protected void invalidate(@Nullable LazyOptional<?> cachedCapability) {
        if (cachedCapability != null && cachedCapability.isPresent()) {
            cachedCapability.invalidate();
        }
    }

    @FunctionalInterface
    public static interface ProxyCreator<HANDLER, SIDED_HANDLER extends HANDLER> {
        public HANDLER create(SIDED_HANDLER var1, @Nullable Direction var2, @Nullable IHolder var3);
    }
}

