/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.chemical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import net.minecraft.util.Direction;

public class ChemicalTankHolder<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>>
implements IChemicalTankHolder<CHEMICAL, STACK, TANK> {
    private final Map<RelativeSide, List<TANK>> directionalTanks = new EnumMap<RelativeSide, List<TANK>>(RelativeSide.class);
    private final List<TANK> tanks = new ArrayList<TANK>();
    private final Supplier<Direction> facingSupplier;

    ChemicalTankHolder(Supplier<Direction> facingSupplier) {
        this.facingSupplier = facingSupplier;
    }

    void addTank(@Nonnull TANK tank, RelativeSide ... sides) {
        this.tanks.add(tank);
        for (RelativeSide side : sides) {
            this.directionalTanks.computeIfAbsent(side, k -> new ArrayList()).add(tank);
        }
    }

    @Override
    @Nonnull
    public List<TANK> getTanks(@Nullable Direction direction) {
        if (direction == null || this.directionalTanks.isEmpty()) {
            return this.tanks;
        }
        RelativeSide side = RelativeSide.fromDirections(this.facingSupplier.get(), direction);
        List<TANK> tanks = this.directionalTanks.get((Object)side);
        if (tanks == null) {
            return Collections.emptyList();
        }
        return tanks;
    }
}

