/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.chemical;

import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.common.tier.GasTankTier;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GasTankGasTank
extends BasicGasTank {
    private final boolean isCreative;
    private final LongSupplier rate;

    public static GasTankGasTank create(GasTankTier tier, @Nullable IMekanismGasHandler gasHandler) {
        Objects.requireNonNull(tier, "Gas tank tier cannot be null");
        return new GasTankGasTank(tier, gasHandler);
    }

    private GasTankGasTank(GasTankTier tier, @Nullable IMekanismGasHandler gasHandler) {
        super(tier.getStorage(), alwaysTrueBi, alwaysTrueBi, (Predicate<Gas>)alwaysTrue, gasHandler);
        this.isCreative = tier == GasTankTier.CREATIVE;
        this.rate = tier::getOutput;
    }

    @Override
    protected long getRate(@Nullable AutomationType automationType) {
        return automationType == AutomationType.INTERNAL ? this.rate.getAsLong() : super.getRate(automationType);
    }

    @Override
    public GasStack insert(GasStack stack, Action action, AutomationType automationType) {
        if (this.isCreative && this.isEmpty() && action.execute() && automationType != AutomationType.EXTERNAL) {
            GasStack simulatedRemainder = super.insert(stack, Action.SIMULATE, automationType);
            if (simulatedRemainder.isEmpty()) {
                this.setStackUnchecked(this.createStack(stack, this.getCapacity()));
            }
            return simulatedRemainder;
        }
        return super.insert(stack, action.combine(!this.isCreative), automationType);
    }

    @Override
    public GasStack extract(long amount, Action action, AutomationType automationType) {
        return (GasStack)super.extract(amount, action.combine(!this.isCreative), automationType);
    }

    @Override
    public long setStackSize(long amount, Action action) {
        return super.setStackSize(amount, action.combine(!this.isCreative));
    }
}

