/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import mekanism.common.ColorRGBA;

public class ColorTemperature
extends ColorRGBA {
    public static Int2ObjectMap<ColorTemperature> cache = new Int2ObjectOpenHashMap();
    public double temp;

    public ColorTemperature(double r, double g, double b, double a, double t) {
        super(r, g, b, a);
        this.temp = t;
    }

    public static ColorTemperature fromTemperature(double temperature, ColorRGBA baseColor) {
        double blue;
        double tmpCalc;
        double red;
        double absTemp = temperature + 300.0;
        if (cache.containsKey((int)(absTemp /= 100.0))) {
            return ((ColorTemperature)cache.get((int)absTemp)).blendOnto(baseColor);
        }
        double effectiveTemp = absTemp;
        if (effectiveTemp < 10.0) {
            effectiveTemp = 10.0;
        }
        if (effectiveTemp > 400.0) {
            effectiveTemp = 400.0;
        }
        if (effectiveTemp <= 66.0) {
            red = 1.0;
        } else {
            tmpCalc = effectiveTemp - 60.0;
            tmpCalc = 329.698727446 * Math.pow(tmpCalc, -0.1332047592);
            red = tmpCalc / 255.0;
        }
        if (effectiveTemp <= 66.0) {
            tmpCalc = effectiveTemp;
            tmpCalc = 99.4708025861 * Math.log(tmpCalc) - 161.1195681661;
        } else {
            tmpCalc = effectiveTemp - 60.0;
            tmpCalc = 288.1221695283 * Math.pow(tmpCalc, -0.0755148492);
        }
        double green = tmpCalc / 255.0;
        if (effectiveTemp >= 66.0) {
            blue = 1.0;
        } else if (effectiveTemp <= 19.0) {
            blue = 0.0;
        } else {
            tmpCalc = effectiveTemp - 10.0;
            tmpCalc = 138.5177312231 * Math.log(tmpCalc) - 305.0447927307;
            blue = tmpCalc / 255.0;
        }
        double alpha = temperature / 1000.0;
        red = Math.min(Math.max(red, 0.0), 1.0);
        green = Math.min(Math.max(green, 0.0), 1.0);
        blue = Math.min(Math.max(blue, 0.0), 1.0);
        alpha = Math.min(Math.max(alpha, 0.0), 1.0);
        ColorTemperature colorTemperature = new ColorTemperature(red, green, blue, alpha, temperature);
        cache.put((int)absTemp, (Object)colorTemperature);
        return colorTemperature.blendOnto(baseColor);
    }

    public ColorTemperature blendOnto(ColorRGBA baseColor) {
        double sR = (double)(this.valR & 0xFF) / 255.0;
        double sG = (double)(this.valG & 0xFF) / 255.0;
        double sB = (double)(this.valB & 0xFF) / 255.0;
        double sA = (double)(this.valA & 0xFF) / 255.0;
        double dR = (double)(baseColor.valR & 0xFF) / 255.0;
        double dG = (double)(baseColor.valG & 0xFF) / 255.0;
        double dB = (double)(baseColor.valB & 0xFF) / 255.0;
        double dA = (double)(baseColor.valA & 0xFF) / 255.0;
        double rR = sR * sA + dR * (1.0 - sA);
        double rG = sG * sA + dG * (1.0 - sA);
        double rB = sB * sA + dB * (1.0 - sA);
        double rA = dA * 1.0 + sA * (1.0 - dA);
        return new ColorTemperature(rR, rG, rB, rA, this.temp);
    }
}

